Ext.ns('Nexts.form');

Nexts.form.FormBtnControl = function(config) {
	Ext.apply(this, config);
};

Ext.apply(Nexts.form.FormBtnControl.prototype, {
	disableOnAction: true,

	init: function(form) {
		this.form = form;
		
		form.on({
			actioncomplete: this.onAfterAction,
			actionfailed: this.onAfterAction,
			beforeaction: this.onBeforeAction,
			scope: this
		});
	},
	
	onBeforeAction: function(form, action) {
		if (this.disableOnAction) {
			this.disableButtons();
		}
	},
	
	onAfterAction: function(form, action) {
		if (this.disableOnAction) {
			this.restoreButtons();
		}
	},
	
	disableButtons: function() {
		if (!this.buttonState) {
			this.buttonState = [];
			for (var i = 0; i < this.form.buttons.length; i++) {
				var b = this.form.buttons[i];
				this.buttonState.push(b.disabled);
				b.setDisabled(true);
			}
		}
	},
	
	restoreButtons: function() {
		if (this.buttonState) {
			for (var i = 0; i < this.form.buttons.length; i++) {
				this.form.buttons[i].setDisabled(this.buttonState[i]);
			}
			delete this.buttonState;
		}
	}
});

