Ext.ns('Nexts'); 

/**
 * @class Nexts.ShortcutButton
 * @extends Ext.Button
 */
Nexts.ShortcutButton = function(config) {
	if (!Nexts.ShortcutButton.buttonTemplate) {
        Nexts.ShortcutButton.buttonTemplate = new Ext.Template(
			'<div class="ne-shortcut-btn"><div>',
				'<img src="' + Ext.BLANK_IMAGE_URL + '" />',
				'<div class="ne-shortcut-btn-text">{0}</div>',
			'</div></div>');
	}
	
	delete config.icon;
	delete config.iconCls;
	
	config.template = Nexts.ShortcutButton.buttonTemplate;

	Nexts.ShortcutButton.superclass.constructor.apply(this, arguments);
	
};

Ext.extend(Nexts.ShortcutButton, Ext.Button, {

	buttonSelector: 'div:first',
	
	initButtonEl: function(btn, btnEl) {
		Nexts.ShortcutButton.superclass.initButtonEl.apply(this, arguments);
		
		btn.removeClass("x-btn");

		var img = btnEl.first();
		
		if (this.shortcutIcon) {
			img.dom.src = this.shortcutIcon;
		}		
		else if (this.shortcutIconCls) {
			img.addClass(this.shortcutIconCls);
		}
	},
	
	autoWidth: function() {
		// do nothing
	},
	
	/**
	 * Sets this shortcut button's text
	 * @param {String} text The button text
	 */
	setText: function(text) {
		this.text = text;
		if (this.el) {
			this.el.child("div.ne-shortcut-btn-text").update(text);
		}
	}
});
