Ext.ns('Nexts'); 

Nexts.PagingToolbar = Ext.extend(Ext.PagingToolbar, {
	loadErrorText: 'Data load failed!',
	
	displayInfo: true,

	// private
	onRender : function(ct, position) {
		Nexts.PagingToolbar.superclass.onRender.apply(this, arguments);
		if (this.displayEl) {
			this.displayEl.on({
				click: this.onDisplayClick,
				scope: this
			});
		}
	},
	
    // private
	updateInfo : function(){
		if (this.detailPopup) {
			this.detailPopup.destroy();
			delete this.detailPopup;
		}
		Nexts.PagingToolbar.superclass.updateInfo.apply(this, arguments);
	},

	// private
	onLoadError : function(proxy, options, response, e) {
		Nexts.PagingToolbar.superclass.onLoadError.apply(this, arguments);
		
		if (this.displayEl) {
			this.displayEl.update('');
			this.displayEl.createChild({
				tag: 'div',
				cls: 'ne-paging-display',
				html: '<table border="0" cellspacing="0" cellpadding="0"><tr>'
					+ '<td class="ne-paging-display-error">&#160;</td>'
					+ '<td>' + this.loadErrorText + '</td>'
					+ '<td class="ne-paging-display-detail">&#160;</td>'
					+ '</tr></table>'
			});
		}

		if (this.detailPopup) {
			this.detailPopup.destroy();
		}

		this.detailPopup = new Nexts.AjaxResponsePopup({
			response: response
		});
	},
	
	onDisplayClick: function(e, target) {
		if (target.className == 'ne-paging-display-detail') {
			e.stopEvent();
			this.detailPopup.show(target, "br-tr?");
		}
	},
	
	onDestroy: function() {
		if (this.detailPopup) {
			this.detailPopup.destroy();
			delete this.detailPopup;
		}
		if (this.displayEl) {
			Ext.destroy(this.displayEl);
			delete this.displayEl;
		}
		Nexts.PagingToolbar.superclass.onDestroy.apply(this, arguments);
	}
});

