Ext.ns('Nexts'); 

Nexts.NotificationMgr = {
    positions: []
};

Nexts.Notification = Ext.extend(Ext.Window, {
	hideDelay: 5000,
	
	align: 'br-tr',
	
	slide: 'b',
	
	initComponent: function() {
		Ext.apply(this, {
			iconCls: this.iconCls || 'ne-icon-information', 
			width: 200,
			autoHeight: true,
			closable: true,
			plain: false,
			draggable: false,
			resizable: false,
			bodyStyle: 'background-color:#FFFFFF;text-align:left;padding:10px;'
		});
		if (this.autoDestroy) {
			this.task = new Ext.util.DelayedTask(this.close, this);
		}
		else {
			this.closable = true;
		}
		Nexts.Notification.superclass.initComponent.call(this);
    },

	setMessage: function(msg) {
		this.body.update(msg);
	},
	
	setTitle: function(title, iconCls) {
        Nexts.Notification.superclass.setTitle.call(this, title, iconCls||this.iconCls);
    },

	onDestroy: function() {
		Nexts.NotificationMgr.positions.remove(this.pos);
		Nexts.Notification.superclass.onDestroy.call(this);
	},

	afterShow: function() {
		Nexts.Notification.superclass.afterShow.call(this);
		this.on('move', function() {
			Nexts.NotificationMgr.positions.remove(this.pos);
			if (this.autoDestroy) {
				this.task.cancel();
			}
		}, this);
		if (this.autoDestroy) {
			this.task.delay(this.hideDelay);
		}
	},

	animShow: function() {
		this.pos = 0;
		while(Nexts.NotificationMgr.positions.indexOf(this.pos)>-1) {
			this.pos++;
		}
		Nexts.NotificationMgr.positions.push(this.pos);
		this.setSize(200,100);
		this.el.alignTo(this.animateTarget || Ext.getBody(), this.align, [
			 -1, -1-((this.getSize().height+10)*this.pos) ]);
		this.el.slideIn(this.slide, {
			duration: .7,
			callback: this.afterShow,
			scope: this
		});
	},

	animHide: function() {
		Nexts.NotificationMgr.positions.remove(this.pos);
		this.el.ghost(this.slide, {
			duration: 1,
			remove: true
		});
	}
});
