Ext.ns('Nexts.frame');

Nexts.frame.QuickStart = function(config) {
	config = config || {};
	config.layout = 'n.line';
	Nexts.frame.QuickStart.superclass.constructor.call(this, config);
};

Ext.extend(Nexts.frame.QuickStart, Ext.Panel, {
    scrollIncrement: 20,

	onRender: function() {
		Nexts.frame.QuickStart.superclass.onRender.apply(this, arguments);
		this.lel = this.body.createChild({
			id: 'ne-frame-qsleft',
			tag: 'img',
			cls: 'ne-icon-arrow-left',
			src: Ext.BLANK_IMAGE_URL,
			border: 0,
			alt: ''
		});
		this.rel = this.body.createChild({
			id: 'ne-frame-qsright',
			tag: 'img',
			cls: 'ne-icon-arrow-right',
			src: Ext.BLANK_IMAGE_URL,
			border: 0,
			alt: ''
		});
		
		this.lel.on({
			mousedown: function() {
				if (!this.timer) {
					this.timer = setInterval(this.scrollShortcuts.createDelegate(this, [-1]), 50);
				}
			},
			mouseup: this.clearTimer,
			scope: this
		});
		this.rel.on({
			mousedown: function() {
				if (!this.timer) {
					this.timer = setInterval(this.scrollShortcuts.createDelegate(this, [1]), 50);
				}
			},
			mouseup: this.clearTimer,
			scope: this
		});
		
		this.body.on({
			mousewheel: function(e) {
				e.stopEvent();
				this.scrollShortcuts(-e.getWheelDelta());
			},
			scope: this
		});
	},
	
	clearTimer: function() {
		if (this.timer) {
			clearInterval(this.timer);
			delete this.timer;
		}
	},
	
	scrollShortcuts: function(dir) {
        var d = dir * this.scrollIncrement;
		var wp = this.body.child('.ne-line-layout');
		if (wp) {
			wp.dom.scrollLeft += d;
			this.updateButtonState(wp);
		}
	},
	
	onDestroy: function() {
		if (this.lel) {
			Ext.destroy(this.lel);
			delete this.lel;
		}
		if (this.rel) {
			Ext.destroy(this.rel);
			delete this.rel;
		}
		Nexts.frame.QuickStart.superclass.onDestroy.apply(this, arguments);
	},
	
	onResize: function() {
		Nexts.frame.QuickStart.superclass.onResize.apply(this, arguments);
		this.updateTableWidth();
	},
	
	doLayout: function() {
		Nexts.frame.QuickStart.superclass.doLayout.apply(this, arguments);
		this.updateTableWidth();
	},

	updateButtonState: function(wp) {
		if (!wp) {
			wp = this.body.child('.ne-line-layout');
		}
		this.lel.setVisible(wp.dom.scrollLeft > 0);
		this.rel.setVisible(wp.dom.scrollLeft + wp.dom.offsetWidth < wp.dom.scrollWidth);
	},
	
	updateTableWidth: function() {
		var wp = this.body.child('.ne-line-layout');
		if (wp) {
			this.lel.setX(wp.getX() - 26);
			this.rel.setX(this.body.getWidth() - 30);
			wp.setWidth(this.rel.getX() - wp.getX() - 10);
			this.updateButtonState(wp);
		}
	},
		
	addQuickStart: function(config) {
		if (!config.id) {
			config.id = Ext.id();
		}
		
		var btn = new Nexts.ShortcutButton(Ext.apply(config, {
			id: 'quickstart.button.' + config.id,
			cls: 'ne-frame-quickstart-btn',
			text: String.ellipsiz(config.text, 20)
		}));

		this.add(btn);
		
		this.doLayout();
		
		return btn;
	},
	
	removeQuickStart: function(b) {
		this.remove(b, true);
		this.doLayout();
	}
});

