Ext.ns('Nexts.frame');

Nexts.frame.Frame = function(config) {
	
	config = config || {};
	
	this.startMenu = new Nexts.frame.StartMenu(Ext.applyIf({
		id: 'ne-frame-startmenu',
		region: 'west',
		stateful: true,
		split: true,
		useSplitTips: true,
		collapsible: true,
		width: 150
	}, config.startConfig));
	
	this.quickstart = new Nexts.frame.QuickStart({
		id: 'ne-frame-quickstart',
		region: 'north',
		header: false
	});

	this.shortcuts = new Nexts.frame.Shortcuts({
		id: 'ne-frame-shortcuts',
		title: '&nbsp;',
		iconCls: 'ne-icon-star',
		border: false
	});

	this.tabPanel = new Ext.TabPanel({
		id: 'ne-frame-tab',
		region: 'center',
		autoDestroy: false,
		enableTabScroll: true,
		layoutOnTabChange : true,
		activeItem: 0,
		plugins: [
			new Nexts.plugins.TabCloseMenu()
		],
		items: [ 
			this.shortcuts 
		],
		listeners : {
			beforeremove: function(t, c) {
				return c.fireEvent('beforeclose', c);
			},
			remove: function(tab, c) {
				c.fireEvent('close', c);
				c.destroy();
			}
		}
	});

	Nexts.frame.Frame.superclass.constructor.call(this, {
		id: 'ne-frame-vp',
		stateful: true,
		layout: 'border',
		items: [
			this.startMenu, this.quickstart, this.tabPanel
		]
	});
};

Ext.extend(Nexts.frame.Frame, Ext.Viewport, {
	waitText				: 'Please wait',
	wallpaperLoadingText	: 'Loading wallpaper...',
	finishedText			: 'Finished',
	wallpaperLoadedText		: 'Wallpaper loaded.',

	initMenuModule: function() {
	},
	
	createWindow: function(cfg, cls) {
		cfg = cfg || {};

		if (!cfg.id && cfg.module) {
			cfg.id = cfg.module.id + '.tab';
		}

		var win;
		if (cfg.resizable === false) {
			cfg.header = false;
			var p = new (cls || Ext.Panel) (cfg);
			win = new Ext.Panel({
				id: cfg.id + '.wrap',
				title: cfg.title,
				iconCls: cfg.iconCls,
				closable: cfg.closable,
				border: false,
				frame: true,
//				layout: 'r.cell',
				items: p
			});
			p.on({
				titlechange: function(p, t) {
					win.setTitle(t);
				}
			});
		}
		else {
			win = new (cls || Ext.Panel)(cfg);
		}

		this.tabPanel.add(win);
		
		return win;
	},

	activateWindow: function(w) {
		this.tabPanel.activate(w);
	},
	
	closeWindow: function(w) {
		this.tabPanel.remove(w);
	},
	
	setTitle: function(title, iconCls) {
		this.startMenu.setTitle(title, iconCls);
	},
	
	setBackgroundColor: function(color) {
	},
	
	setFontColor: function(color) {
		if (color) {
			Ext.util.CSS.updateRule('.ne-shortcut-btn-text', 'color', '#' + color);
			this.config.styles.fontcolor = color;
		}
	},
	
	setTheme: function(o) {
		if (o && o.css) {
			Ext.util.CSS.swapStyleSheet(Nexts.Theme.cssId, Nexts.Theme.cssPath + o.css);
			this.config.styles.theme = o;
		}
	},
	
	setTransparency: function(b) {
	},
	
	setWallpaper: function(w) {
		if (w) {
			if (w.image) {
				this.setWallpaperImage(w.image);
			}
			if (w.position) {
				this.setWallpaperPosition(w.position);
			}
		}
	},
	
	setWallpaperImage: function(img) {
		if (img) {
			var notifyWin = this.showNotification({
				iconCls: 'ne-icon-wait',
				title: this.waitText,
				html: this.wallpaperLoadingText
			});
			
			var wp = new Image();
			wp.src = img;
			
			var task = new Ext.util.DelayedTask(verify, this);
			task.delay(200);
			
			this.config.styles.wallpaper.image = img;
		}
		
		function verify() {
			if (wp.complete && this.shortcuts.body) {
				task.cancel();
				
				notifyWin.setIconClass('ne-icon-information');
				notifyWin.setTitle(this.finishedText);
				notifyWin.setMessage(this.wallpaperLoadedText);
				this.hideNotification(notifyWin);
				
				this.shortcuts.body.background = wp.src;
				this.shortcuts.body.dom.style.backgroundImage = 'url(' + img + ')';
			}
			else {
				task.delay(200);
			}
		}
	},
	
	setWallpaperPosition: function(pos) {
		if (pos) {
			if (pos == "center") {
				this.shortcuts.body.replaceClass('ne-desktop-wallpaper-tile', 'ne-desktop-wallpaper-center');
			}
			else if (pos == "tile") {
				this.shortcuts.body.replaceClass('ne-desktop-wallpaper-center', 'ne-desktop-wallpaper-tile');
			}			
			this.config.styles.wallpaper.position = pos;
		}
	},

	showNotification: function(config) {
		var win = new Nexts.Notification(Ext.apply({
			align: 'tr-br',
			slide: 't',
			animateTarget: this.quickstart.el,
			autoDestroy: true,
			hideDelay: 3000,
			html: '',
			title: ''
		}, config));
		
		win.show();

		return win;
	},
	
	hideNotification: function(win, delay) {
		if (win) {
			(function() { win.animHide(); }).defer(delay || 3000);
		}
	},
	
	addAutoRun: function(id) {
		var c = this.config.launchers.autorun;

		if (!c.contains(id)) {
			c.push(id);
		}
	},
	
	removeAutoRun: function(id) {
		var c = this.config.launchers.autorun;
			
		c.remove(id);
	},
	
	// Private
	addContextMenuItem: function(id) {
	},

	addStartMenu: function(m, tool) {		
		var sm = this.startMenu;
		
		sm.addModule(m, tool);
	},

	addShortcut: function(id, updateConfig) {
		var m = Nexts.module.ModuleManager.getModule(id);
		
		if (m && !m.shortcut) {
			m.shortcut = this.shortcuts.addShortcut(Ext.apply({
				id: id
			}, m.launcher));
			
			if (updateConfig) {
				this.config.launchers.shortcut.push(id);
			}
		}
	},

	removeShortcut: function(id, updateConfig) {
		var m = Nexts.module.ModuleManager.getModule(id);
		
		if (m && m.shortcut) {
			this.shortcuts.removeShortcut(m.shortcut);
			delete m.shortcut;
			
			if (updateConfig) {
				this.config.launchers.shortcut.remove(id);
			}
		}
	},

	addQuickStartButton: function(id, updateConfig) {
		var m = Nexts.module.ModuleManager.getModule(id);
		
		if (m && !m.quickstart) {
			m.quickstart = this.quickstart.addQuickStart(Ext.apply({
				id: id
			}, m.launcher));
			
			if (updateConfig) {
				this.config.launchers.quickstart.push(id);
			}
		}
	},
	
	removeQuickStartButton: function(id, updateConfig) {
		var m = Nexts.module.ModuleManager.getModule(id);
		
		if (m && m.quickstart) {
			this.quickstart.removeQuickStart(m.quickstart);
			delete m.quickstart;
			
			if (updateConfig) {
				this.config.launchers.quickstart.remove(id);
			}
		}
	}
});

