Ext.ns('Nexts.module');

Nexts.module.ModuleGroup = function() {
	this.launches = {};
	this.modules = {};
	this.moduleCount = 0;
};

Ext.apply(Nexts.module.ModuleGroup.prototype, {
	register: function(m) {
		if (this.modules[m.id]) {
			throw 'module (id: ' + m.id + ') already be registered!';
		}
		this.modules[m.id] = m;
		this.moduleCount++;
		
		if (m instanceof Nexts.module.WindowModule) {
			m.on({
				launch: this.onLaunchModule,
				close: this.onCloseModule,
				scope: this
			});
		}
	},

	getModuleCount: function() {
		return this.moduleCount;
	},
	
	getModules: function() {
		return this.modules;
	},
	
	getModule: function(mid) {
		return this.modules[mid];
	},
	
	getLaunchedModules: function() {
		return this.launches;
	},
	
	getLaunchedModule: function(mid) {
		return this.launches[mid];
	},
	
	isModuleLaunched: function(mid) {
		mid = typeof mid == 'object' ? mid.id : mid;
		return typeof this.launches[mid] == 'object';
	},
	
	onLaunchModule: function(m) {
		this.launches[m.id] = m;
	},
	
	onCloseModule: function(m) {
		delete this.launches[m.id];
	}
});

Nexts.module.ModuleManager = new Nexts.module.ModuleGroup();

