Ext.override(Ext.form.Field, {
	readOnlyClass: 'ne-field-readonly',
	
	_setValue: Ext.form.Field.prototype.setValue,
	
	setValue: function(v) {
		if (v !== undefined && v !== null) {
			if (typeof this.convert == 'function') {
				v = this.convert(v);
			}
			else if (this.format) {
				if (Ext.isDate(v)) {
					v = v.format(this.format);
				}
			}
		}
		this._setValue(v);
	},
	
	_onRender: Ext.form.Field.prototype.onRender,
	
	onRender:  function(ct, position) {
		this._onRender.apply(this, arguments);
		this.setReadOnly(this.readOnly);
	},
	
	setReadOnly: function(r) {
		this.readOnly = r ? true : false;
		this.el.dom.readOnly = this.readOnly;
		if (this.readOnly) {
			this.addClass(this.readOnlyClass);
		}
		else {
			this.removeClass(this.readOnlyClass);
		}
	}
});
