if (typeof Ext.data.Record.prototype.initData == 'undefined') {
	Ext.data.Record.prototype.initData = function() {
		this.dirty = false;
		delete this.modified;
		this.fields.each(function(f) {
			this.data[f.name] = f.defaultValue || null;
		}, this);
	};
}

if (typeof Ext.data.Record.prototype.clearData == 'undefined') {
	Ext.data.Record.prototype.clearData = function() {
		this.beginEdit();
		this.fields.each(function(f) {
			this.set(f.name) = f.defaultValue || null;
		}, this);
		this.endEdit();
	};
}

if (typeof Ext.data.Record.prototype.setData == 'undefined') {
	Ext.data.Record.prototype.setData = function(data) {
		this.beginEdit();
		this.fields.each(function(f) {
			var v = data[f.name];
			if (f.convert) {
				v = f.convert(v);
			}
			this.set(f.name) = v;
		}, this);
		this.endEdit();
	};
}
