Ext.ns('Nexts');

var _nexts_applet = null;

Nexts.Applet = function(cfg) {
	if (_nexts_applet != null) {
		console.error('Illegal to create two instance of Nexts.desktop.App');
		return _nexts_applet;
	}

	_nexts_applet = this;

	Ext.apply(this, cfg);

	Ext.QuickTips.init();

	this.cookie = new Ext.state.CookieProvider();
	this.cookie.expires = new Date(new Date().getTime()+(1000*60*60*24*30)); //30 days
		
	Ext.onReady(this.initApp, this);
};

Nexts.Applet.getInstance = function() {
	return _nexts_applet;
};

Ext.extend(Nexts.Applet, Ext.util.Observable, {
	sessionErrorTitle: 'SESSION ERROR',
	applicationErrorTitle: 'APPLICATION ERROR',
	systemExceptionTitle: 'SYSTEM EXCEPTION',
	
	unloginErrorId: 'error-unlogin',
	
	getStartConfig: Ext.emptyFn,
	getDesktopConfig: Ext.emptyFn,

	initApp: function() {
		if (!this.getText) {
			this.getText = Nexts.Resources.getText;
		}
		
		if (this.loginModule) {
			this.loginModule.launchModule();
		}
		else {
			this.initDesktop();
		}
	},

	initDesktop: function() {
		this.initModules();
		
		var sc = this.getStartConfig();
		var dc = this.getDesktopConfig();
		
		dc.layout = dc.layout || 'frame';
		var dl = dc.layout == 'desktop' ? Nexts.desktop.Desktop : Nexts.frame.Frame;
		this.desktop = Nexts.Shell.createDesktop({
			startConfig: sc,
			desktopConfig: dc
		}, dl);

		Ext.Ajax.on({
			requestcomplete: this.onAjaxRequestComplete,
			requestexception: this.onAjaxRequestException,
			delay: 100,
			scope: this
		});
	},

	getDesktop: function() {
		return this.desktop;
	},

	beforeLogout: function() {
		var ms = Nexts.module.ModuleManager.getLaunchedModules();
		for (var mid in ms) {
			var m = ms[mid];
			m.closeModule();
			if (m.isLaunched()) {
				return false;
			}
		}
	},

	onAjaxRequestComplete: function(conn, response, options) {
		try {
			var jo = Ext.decode(response.responseText);
			if (!jo.success) {
				if (jo.exception) {
					this.onSystemException(jo.exception);
				}
				else if (jo.sessionErrors && jo.sessionErrors.length > 0) {
					this.onSessionErrors(jo.sessionErrors);
				}
			}
		}
		catch (ex) {
			console.error(ex);
		}
	},
	
	onAjaxRequestException: function(conn, response, options) {
	},
	
	onLogin: Ext.emptyFn,
	
	onLogout: Ext.emptyFn,

	onUnlogin: function() {
		if (this.loginModule) {
			this.loginModule.launchModule();
		}
	},
	
	onSystemException: function(exception) {
		Ext.Msg.show({
			title: this.exceptionTitle,
			msg: jo.exception.msg,
			icon: Ext.Msg.ERROR,
			buttons: Ext.Msg.OK,
			scope: this
		});
	},
	
	onApplicationErrors: function(errors) {
		var msg = '';
		for (var i = 0; i < errors.length; i++) {
			msg += errors[i].msg + '\r\n';
		}
		Ext.Msg.show({
			title: this.applicationErrorTitle,
			msg: jo.sessionError.msg,
			icon: Ext.Msg.ERROR,
			buttons: Ext.Msg.OK
		});
	},
	
	onSessionErrors: function(errors) {
		var fn = Ext.emptyFn;
		var msg = '';
		for (var i = 0; i < errors.length; i++) {
			if (errors[i].id == this.unloginErrorId) {
				fn = this.onUnlogin;
			}
			msg += errors[i].msg + '\r\n';
		}
		Ext.Msg.show({
			title: this.sessionErrorTitle,
			msg: jo.sessionError.msg,
			icon: Ext.Msg.ERROR,
			buttons: Ext.Msg.OK,
			fn: fn,
			scope: this
		});
	}	
});
