/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.simple;

import java.io.IOException;

import org.apache.struts2.components.template.TemplateRenderingContext;

import nuts.core.lang.StringUtils;
import nuts.exts.struts2.components.Anchor;
import nuts.exts.struts2.views.java.AbstractTemplateRenderer;
import nuts.exts.struts2.views.java.Attributes;

public class NutsUploaderRenderer extends AbstractTemplateRenderer {
	public NutsUploaderRenderer(TemplateRenderingContext context) {
		super(context);
	}

	public void render() throws IOException {
		Attributes attr = new Attributes();
		
		boolean readonly = Attributes.isTrue(params.get("readonly"));
		boolean disabled = Attributes.isTrue(params.get("disabled"));
		
		String pua = (String)params.get("uploadAction");
		String pup = (String)params.get("uploadParam");
		String pda = (String)params.get("dnloadAction");
		String pdp = (String)params.get("dnloadParam");
		String pdl = (String)params.get("defaultLink");
		String pdt = (String)params.get("defaultText");
        
        attr.id(params)
			.addIfExists("uploadAction", pua)
			.addIfExists("uploadParam", pup)
			.addIfExists("dnloadAction", pda)
			.addIfExists("dnloadParam", pdp)
			.addIfExists("defaultLink", pdl)
			.addIfExists("defaultText", pdt)
			.css(this, "n-uploader")
			.title(params)
			.commons(params)
			.events(params)
			.dynamics(params);

		stag("div", attr);
		

		write("<div class=\"n-uploader-progress\"></div>");
		
		Attributes a = new Attributes();
		a.add("type", "file");
		if (readonly) {
			a.add("class", "n-uploader-file n-uploader-hidden");
		}
		else {
			a.add("class", "n-uploader-file");
		}
		a.add("name", "")
		 .add("value", "")
		 .disabled(params)
		 .size(params)
		 .accept(params)
		 .tabindex(params);
		xtag("input", a);

		String name = (String)params.get("name");
		String uct = defs(findString(name + ".contentType"));
		String ufn = defs(findString(name + ".fileName"));
		String usn = defs(findString(name + ".saveName"));
		Long ufs = (Long)(findValue(name + ".fileSize", Long.class));
		
		a = new Attributes();
		a.add("type", "hidden")
		 .add("class", "n-uploader-ct")
		 .disabled(params);
		if (name != null) {
			a.add("name", name + ".contentType");
			a.add("value", uct);
		}
		xtag("input", a);
		
		a = new Attributes();
		a.add("type", "hidden")
		 .add("class", "n-uploader-fn")
		 .addIfTrue("disabled", disabled);
		if (name != null) {
			a.add("name", name + ".fileName");
			a.add("value", ufn);
		}
		xtag("input", a);
		
		a = new Attributes();
		a.add("type", "hidden")
		 .add("class", "n-uploader-fs")
		 .add("disabled", "disabled");
		if (name != null) {
			a.add("name", name + ".fileSize");
			a.add("value", defs(ufs));
		}
		xtag("input", a);
		
		a = new Attributes();
		a.add("type", "hidden")
		 .add("class", "n-uploader-sn")
		 .addIfTrue("disabled", disabled);
		if (name != null) {
			a.add("name", name + ".saveName");
			a.add("value", usn);
		}
		xtag("input", a);

		write("<span class=\"n-uploader-text\"");
		if (readonly || disabled) {
			if (StringUtils.isNotEmpty(ufn)) {
				write(" style=\"display:inline\">");
				if (StringUtils.isNotEmpty(usn)) {
					Anchor at = getAnchorTag();
					at.setCssClass("n-uploader-icon"); 
					at.setHref(pda + '?' + pdp + '=' + html(usn)); 
					at.setIcon("ui-icon-check");
					at.start(writer);
					at.end(writer, ufn + " " + filesize(ufs));
				}
				else {
					write("<span>");
					write(icon("ui-icon ui-icon-check n-a-icon n-uploader-icon"));
					write(ufn);
					write(" ");
					write(filesize(ufs));
					write("</span>");
				}
			}
			else if (StringUtils.isNotEmpty(pdl)) {
				write(" style=\"display:inline\">");
				Anchor at = getAnchorTag();
				at.setCssClass("n-uploader-icon"); 
				at.setHref(pdl); 
				at.setIcon(uct.startsWith("image") ? "n-icon-file_img" : "n-icon-attach");
				at.start(writer);
				at.end(writer, pdt);
			}
			else {
				write(">");
			}
		}
		else {
			write(">");
		}
		write("</span>");

		write("<div class=\"n-uploader-error\"></div>");
		
		write("<div class=\"n-uploader-image\"");
		if (readonly || disabled) {
			if (StringUtils.isNotEmpty(usn) && uct.startsWith("image")) {
				write(" style=\"display:block\">");
				write("<img src=\"" + pda + '?' + pdp + '=' + usn + "\"/>");
			}
			else if (StringUtils.isNotEmpty(pdl) && uct.startsWith("image")) {
				write(" style=\"display:block\">");
				write("<img src=\"" + pdl + "\"/>");
			}
			else {
				write(">");
			}
		}
		else {
			write(">");
		}
		write("</div>");
		if (!(readonly || disabled)) {
			writeJsc("$(function() { nuts.upload('" + jsstr(params.get("id")) + "');});");
		}
		
		etag("div");
    }

	private String filesize(Long fs) {
		String sz = StringUtils.formatFileSize(fs);

		if (sz.length() > 0) {
			sz = '(' + sz + ')';
		}
		return sz;
	}
}
