/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.simple;

import java.io.IOException;
import java.util.Locale;

import org.apache.struts2.components.template.TemplateRenderingContext;

import nuts.core.lang.StringUtils;
import nuts.exts.struts2.views.java.AbstractTemplateRenderer;
import nuts.exts.struts2.views.java.Attributes;

public class NutsLinkRenderer extends AbstractTemplateRenderer {
	public NutsLinkRenderer(TemplateRenderingContext context) {
		super(context);
	}

	private static final String ver = "1.8.2";
	
	private Locale locale;
	private boolean script;
	private boolean style;
	private boolean debug;
	private String version;
	
	public void render() throws IOException {
		locale = (Locale)params.get("locale");
		script = Attributes.isTrue(params.get("script"), true);
		style = Attributes.isTrue(params.get("style"), true);
		debug = Attributes.isTrue(params.get("debug"), false);
		version = StringUtils.defaultString((String)params.get("version"), ver);

		writeJquery();
		writeJqueryUI();
		writeJqueryPlugins();
		writeNuts();
		writeExtjs();
		writeExtux();
		writeNexts();
	}

	protected void writeJsc(String jsc) throws IOException {
		if (script) {
			super.writeJsc(jsc);
		}
	}
	protected void writeJs(String js) throws IOException {
		if (script) {
			super.writeJs(base() + js + ".js?v=" + version);
		}
	}

	protected void writeCss(String css, String cls) throws IOException {
		if (style) {
			super.writeCss(base() + css + ".css?v=" + version, cls);
		}
	}

	private void writeJquery() throws IOException {
		if (Attributes.isTrue(params.get("jquery"))) {
			writeJs("/static/jquery/jquery-1.6.2" + (debug ? "" : ".min"));
		}
	}

	private String getJqueryLang() {
		String la = locale.getLanguage();
		if ("fr".equals(la)) {
			la += "-CH";
		}
		else if ("pt".equals(la)) {
			la += "-BR";
		}
		else if ("sr".equals(la)) {
			la += "-SR";
		}
		else if ("zh".equals(la)) {
			if ("TW".equalsIgnoreCase(locale.getCountry())) {
				la += "-TW";
			}
			else if ("HK".equalsIgnoreCase(locale.getCountry())) {
				la += "-HK";
			}
			else {
				la += "-CN";
			}
		}
		return la;
	}

	private void writeJqueryUI() throws IOException {
		if (Attributes.isTrue(params.get("jqueryUi"))) {
			writeCss("/static/jquery/themes/" 
					+ defs((String)params.get("uiTheme"), "cupertino")
					+ "/jquery-ui",
					"ui-theme");
			
			writeJs("/static/jquery/jquery-ui-1.8.16" + (debug ? "" : ".min"));
			
			String la = getJqueryLang();
			if (Attributes.isTrue(params.get("jqueryI18N"))) {
				writeJs("/static/jquery/jquery-ui-i18n" + (debug ? "" : ".min"));
				
				writeJsc("$(function() { $.datepicker.setDefaults($.datepicker.regional['" + jsstr(la) + "']); });");
			}
			else {
				writeJs("/static/jquery/ui/i18n/jquery.ui.datepicker-" + jsstr(la));
			}
		}
	}

	private void writeJqueryPlugins() throws IOException {
		if (Attributes.isTrue(params.get("jqueryPlugins"))) {
			writeCss("/static/jquery/plugins/jquery-plugins");

			writeJs("/static/jquery/jquery-plugins" + (debug ? "" : ".min"));

			String la = getJqueryLang();
			if ("ja".equals(la) || la.startsWith("zh")) {
				writeJs("/static/jquery/plugins/i18n/jquery-plugins-"
						+ jsstr(la)
						+ (debug ? "" : ".min"));
			}
		}
	}
	
	private void writeNuts() throws IOException {
		if (Attributes.isTrue(params.get("nuts"))) {
			writeCss("/static/nuts/css/nuts");

			writeJs("/static/nuts/js/nuts" + (debug ? "" : ".min"));
		}
	}

	private String getExtjsLang() {
		String la = locale.getLanguage();
		if ("el".equals(la)) {
			la += "_GR";
		}
		else if ("en".equals(la)) {
			if ("GB".equalsIgnoreCase(locale.getCountry())) {
				la += "_GB";
			}
		}
		else if ("fr".equals(la)) {
			if ("CA".equalsIgnoreCase(locale.getCountry())) {
				la += "_CA";
			}
		}
		else if ("no".equals(la)) {
			if ("NB".equalsIgnoreCase(locale.getCountry())) {
				la += "_NB";
			}
			else {
				la += "_NN";
			}
		}
		else if ("pt".equals(la)) {
			if ("BR".equalsIgnoreCase(locale.getCountry())) {
				la += "_BR";
			}
			else if ("PT".equalsIgnoreCase(locale.getCountry())) {
				la += "_PT";
			}
		}
		else if ("sr".equals(la)) {
			if ("RS".equalsIgnoreCase(locale.getCountry())) {
				la += "_RS";
			}
		}
		else if ("sv".equals(la)) {
			la += "_SE";
		}
		else if ("zh".equals(la)) {
			if ("TW".equalsIgnoreCase(locale.getCountry())) {
				la += "_TW";
			}
			else if ("HK".equalsIgnoreCase(locale.getCountry())) {
				la += "_TW";
			}
			else {
				la += "_CN";
			}
		}
		return la;
	}

	private void writeExtjs() throws IOException {
		if (Attributes.isTrue(params.get("extjs"))) {
			writeCss("/static/extjs/resources/css/ext-all");
			
			writeCss("/static/extjs/resources/css/xtheme-"
					+ defs((String)params.get("exTheme"), "blue"), 
					"ex-theme");

			if (Attributes.isTrue(params.get("jquery"))) {
				writeJs("/static/extjs/adapter/jquery/ext-jquery-adapter");
			}
			else {
				writeJs("/static/extjs/adapter/ext/ext-base" + (debug ? "-debug" : ""));
			}

			String la = getExtjsLang();
			writeJs("/static/extjs/ext-all" + (debug ? "-debug" : ""));
			writeJs("/static/extjs/locale/ext-lang-" + jsstr(la));
		}
	}

	private void writeExtux() throws IOException {
		if (Attributes.isTrue(params.get("extux"))) {
			writeCss("/static/extjs/resources/css/ext-ux-all");
			writeJs("/static/extjs/ext-ux-all" + (debug ? "-debug" : ""));
		}
	}
	
	private String getNextsLang() {
		String la = locale.getLanguage();
		if ("zh".equals(la)) {
			if ("TW".equalsIgnoreCase(locale.getCountry())) {
				la += "-TW";
			}
			else if ("HK".equalsIgnoreCase(locale.getCountry())) {
				la += "-TW";
			}
			else {
				la += "-CN";
			}
		}
		return la;
	}

	private void writeNexts() throws IOException {
		if (Attributes.isTrue(params.get("nexts"))) {
			writeCss("/static/nexts/css/nexts-all");
			writeJs("/static/nexts/nexts-all" + (debug ? "" : ".min"));
			
			String la = getNextsLang();
			writeJs("/static/nexts/locale/nexts-lang-" + jsstr(la) + (debug ? "" : ".min"));
		}
	}
}
