/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.simple;

import java.io.IOException;

import org.apache.struts2.components.template.TemplateRenderingContext;

import nuts.exts.struts2.views.java.AbstractTemplateRenderer;
import nuts.exts.struts2.views.java.Attributes;

public class CheckboxRenderer extends AbstractTemplateRenderer {
	public CheckboxRenderer(TemplateRenderingContext context) {
		super(context);
	}

	public void render() throws IOException {
        Attributes attrs = new Attributes();

        String fieldValue = (String) params.get("fieldValue");
        String id = (String) params.get("id");
        String name = (String) params.get("name");
        Object disabled = params.get("disabled");

        attrs.add("type", "checkbox")
                .id(params)
                .name(params)
                .css(this)
                .add("value", fieldValue)
                .addIfTrue("checked", params.get("nameValue"))
                .readonly(params)
                .disabled(params)
                .tabindex(params)
                .title(params)
                .commons(params)
                .events(params)
                .dynamics(params);
        xtag("input", attrs);

        //hidden input
        attrs = new Attributes();
        attrs.add("type", "hidden")
                .add("id", "__checkbox_" + id)
                .add("name", "__checkbox_" + name)
                .add("value", fieldValue)
                .addIfTrue("disabled", disabled);
        xtag("input", attrs);
    }
}
