/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.nthtml;

import org.apache.struts2.components.template.TemplateRenderingContext;

import nuts.core.lang.ClassUtils;
import nuts.exts.struts2.views.java.TemplateRenderer;
import nuts.exts.struts2.views.java.TemplateRendererFactory;


/**
 * Default implementation of TagHandlerFactory 
 */
public class NthtmlTemplateRendererFactory implements TemplateRendererFactory {
    private Class<? extends NthtmlTemplateRenderer> nxhtmlRendererClass;
    private Class<? extends TemplateRenderer> simpleRendererClass;

	public NthtmlTemplateRendererFactory(
			Class<? extends NthtmlTemplateRenderer> nxhtmlRendererClass,
			Class<? extends TemplateRenderer> simpleRendererClass) {
		super();
		this.simpleRendererClass = simpleRendererClass;
		this.nxhtmlRendererClass = nxhtmlRendererClass;
	}

	public TemplateRenderer create(TemplateRenderingContext context) throws Exception {
		NthtmlTemplateRenderer nthtmlRenderer = (NthtmlTemplateRenderer)ClassUtils.newInstance(nxhtmlRendererClass, context, TemplateRenderingContext.class);
		TemplateRenderer simpleRenderer = (TemplateRenderer)ClassUtils.newInstance(simpleRendererClass, context, TemplateRenderingContext.class);
		nthtmlRenderer.setSimpleRenderer(simpleRenderer);
		return nthtmlRenderer;
	}
}
