/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.nthtml;

import org.apache.struts2.components.template.TemplateRenderingContext;

import nuts.core.lang.StringUtils;

public class ButtonWrapper extends NthtmlTemplateRenderer {
	/**
	 * @param context context
	 */
	public ButtonWrapper(TemplateRenderingContext context) {
		super(context);
	}

	protected void renderHeader() throws Exception {
		String nthtml_group = (String)findInContext("nthtml_group");
		if (StringUtils.isEmpty(nthtml_group)) {
			write("<tr class=\"n-tr-submit\">");
			write("<td class=\"n-td-label\"></td>");
			write("<td class=\"n-td-submit\">");
		}
		write((String)params.get("before"));
		
		String group = (String)params.get("group");
		if ("start".equals(group)) {
			putInContext("nthtml_group", defs((String)params.get("name"), "-"));
		}
		else if (StringUtils.isNotEmpty(nthtml_group)) {
			putInContext("nthtml_group", nthtml_group + "," + defs((String)params.get("name"), "-"));
		}
	}
	
	protected void renderFooter() throws Exception {
		String nthtml_group = (String)findInContext("nthtml_group");
		String group = (String)params.get("group");

        write((String)params.get("after"));

		if (StringUtils.isEmpty(nthtml_group) || "end".equals(group)) {
			etag("td");
			etag("tr");
		}

		if ("end".equals(group)) {
			putInContext("nthtml_group", "");
		}
	}
	
	public void render() throws Exception {
		renderHeader();
		renderSimple();
		renderFooter();
	}

}
