/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.components;

import java.io.Writer;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nuts.core.lang.StringUtils;
import nuts.core.servlet.HttpServletUtils;
import nuts.exts.xwork2.util.ContextUtils;

import org.apache.struts2.StrutsException;
import org.apache.struts2.components.Component;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

import com.opensymphony.xwork2.util.ValueStack;


/**
 * <!-- START SNIPPET: javadoc -->
 *
 * Write http header.
 *
 * <p/>
 *
 * Configurable attributes are :-
 * <ul>
 *    <li>contentType</li>
 *    <li>charset</li>
 *    <li>bom</li>
 *    <li>attachment</li>
 *    <li>filename</li>
 *    <li>locale</li>
 *    <li>noCache</li>
 * </ul>
 *
 * <p/>
 *
 * <!-- END SNIPPET: javadoc -->
 *
 * <p/> <b>Examples</b>
 * <pre>
 *  <!-- START SNIPPET: example -->
 *  &lt;r:head noCache="true" /&gt;
 *  <!-- END SNIPPET: example -->
 * </pre>
 *
 */
@StrutsTag(
	name="head",
	tldBodyContent="empty",
	tldTagClass="nuts.exts.struts2.views.jsp.HeadTag",
	description="Render head.")
public class Head extends Component {
	// attributes
    protected HttpServletRequest request;
    protected HttpServletResponse response;

	protected String locale;
	protected String contentType;
	protected String charset;
	protected String bom;
	protected String attachment;
	protected String filename;
	protected String noCache;

	/**
	 * Constructor
	 *
	 * @param stack value stack
	 * @param request request
	 * @param response response
	 */
	public Head(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
		super(stack);
        this.request = request;
        this.response = response;
	}

	/**
	 * Evaluate parameters
	 */
	protected void evaluateParams() {
		if (locale != null) {
			addParameter("locale", findValue(locale, Locale.class));
		}
		else {
			addParameter("locale", ContextUtils.getLocale());
		}

		if (contentType != null) {
			addParameter("contentType", findString(contentType));
		}
		if (charset != null) {
			addParameter("charset", findString(charset));
		}
		if (bom != null) {
			addParameter("bom", findValue(bom, Boolean.class));
		}
		if (attachment != null) {
			addParameter("attachment", findValue(attachment, Boolean.class));
		}
		if (filename != null) {
			addParameter("filename", findString(filename));
		}
		if (noCache != null) {
			addParameter("noCache", findValue(noCache, Boolean.class));
		}
	}

    /**
     * Callback for the end tag of this component.
     * Should the body be evaluated again?
     * <p/>
     * <b>NOTE:</b> will pop component stack.
     * @param writer  the output writer.
     * @param body    the rendered body.
     * @return true if the body should be evaluated again
     */
    public boolean end(Writer writer, String body) {
        evaluateParams();

        try {
        	String filename = (String)parameters.get("filename");
        	if (StringUtils.isNotEmpty(filename)) {
        		addParameter("filename", filename);
        	}
        	HttpServletUtils.setResponseHeader(request, response, getParameters());
            
        	super.end(writer, body, false);
        }
        catch (Exception e) {
            throw new StrutsException(e);
        }
        finally {
            popComponentStack();
        }
		return false;
	}

	/**
	 * @param noCache the noCache to set
	 */
	@StrutsTagAttribute(description="Whether the reponse is noCache")
	public void setNoCache(String noCache) {
		this.noCache = noCache;
	}

	/**
	 * @param contentType the contentType to set
	 */
	@StrutsTagAttribute(description = "the property for content type")
	public void setContentType(String contentType) {
		this.contentType = contentType;
	}

	/**
	 * @param attachment the attachment to set
	 */
	@StrutsTagAttribute(description = "the property for attachment")
	public void setAttachment(String attachment) {
		this.attachment = attachment;
	}

	/**
	 * @param filename the filename to set
	 */
	@StrutsTagAttribute(description = "the property for content disposition filename")
	public void setFilename(String filename) {
		this.filename = filename;
	}

	/**
	 * @param charset the charset to set
	 */
	@StrutsTagAttribute(description = "the property for charset")
	public void setCharset(String charset) {
		this.charset = charset;
	}

	/**
	 * @param bom the bom to set
	 */
	@StrutsTagAttribute(description = "the property for bom")
	public void setBom(String bom) {
		this.bom = bom;
	}

	/**
	 * @param locale the locale to set
	 */
	@StrutsTagAttribute(description = "the property for locale")
	public void setLocale(String locale) {
		this.locale = locale;
	}
}

