/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.components;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.components.Param.UnnamedParametric;
import org.apache.struts2.components.UIBean;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

import com.opensymphony.xwork2.util.ValueStack;

/**
 * <!-- START SNIPPET: javadoc --> Render field errors if they exists. Specific layout depends on
 * the particular theme. <!-- END SNIPPET: javadoc -->
 * <p/>
 * <b>Examples</b>
 * 
 * <pre>
 * &lt;!-- START SNIPPET: example --&gt;
 *    &lt;!-- example 1 --&gt;
 *    &lt;s:fielderror /&gt;
 *    &lt;!-- example 2 --&gt;
 *    &lt;s:fielderror&gt;
 *         &lt;s:param&gt;field1&lt;/s:param&gt;
 *         &lt;s:param&gt;field2&lt;/s:param&gt;
 *    &lt;/s:fielderror&gt;
 *    &lt;s:form .... &gt;
 *       ....
 *    &lt;/s:form&gt;
 *    OR
 *    &lt;s:fielderror&gt;
 *          &lt;s:param value=&quot;%{'field1'}&quot; /&gt;
 *          &lt;s:param value=&quot;%{'field2'}&quot; /&gt;
 *    &lt;/s:fielderror&gt;
 *    &lt;s:form .... &gt;
 *       ....
 *    &lt;/s:form&gt;
 * &lt;!-- END SNIPPET: example --&gt;
 * </pre>
 * <p/>
 * <b>Description</b>
 * <p/>
 * 
 * <pre>
 * &lt;!-- START SNIPPET: description --&gt;
 * Example 1: display all field errors&lt;p/&gt;
 * Example 2: display field errors only for 'field1' and 'field2'&lt;p/&gt;
 * &lt;!-- END SNIPPET: description --&gt;
 * </pre>
 */
@SuppressWarnings("unchecked")
@StrutsTag(
		name = "fielderror", 
		tldTagClass = "nuts.exts.struts2.views.jsp.ui.FieldErrorTag", 
		description = "Render field error (all or partial depending on param tag nested)if they exists")
public class FieldError extends UIBean implements UnnamedParametric {

	private List errorFieldNames = new ArrayList();
    private boolean escape = true;

	/**
	 * Constructor
	 * 
	 * @param stack value stack
	 * @param request request
	 * @param response response
	 */
	public FieldError(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
		super(stack, request, response);
	}

	private static final String TEMPLATE = "n-fielderror";

	protected String getDefaultTemplate() {
		return TEMPLATE;
	}

	protected void evaluateExtraParams() {
		if (label != null) {
			addParameter("label", findValue(label, Boolean.class));
		}
        if (errorFieldNames != null) {
            addParameter("errorFieldNames", errorFieldNames);
        }
        
        addParameter("escape", escape);
	}

	/**
	 * @param value the value to add
	 */
	public void addParameter(Object value) {
		if (value != null) {
			errorFieldNames.add(value.toString());
		}
	}

	/**
	 * @return error field name list
	 */
	public List getFieldErrorFieldNames() {
		return errorFieldNames;
	}

    @StrutsTagAttribute(description="Field name for single field attribute usage", type="String")
    public void setFieldName(String fieldName) {
        addParameter(fieldName);
    }

    @StrutsTagAttribute(description=" Whether to escape HTML", type="Boolean", defaultValue="true")
    public void setEscape(boolean escape) {
        this.escape = escape;
    }
}
