/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.actions;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nuts.core.servlet.HttpServletSupport;
import nuts.exts.fileupload.UploadImage;

import org.apache.commons.vfs.FileContent;

/**
 * Image download/upload for temporary image
 */
@SuppressWarnings("serial")
public class ImageServeAction extends CommonServletAction {

	protected boolean cache = true;
	protected int bufferSize = 4096;
	protected String contentDisposition;

	private UploadImage image = new UploadImage();
	private int width = 0;
	private int height = 0;
	private int scale = 0;
	
	/**
	 * @return the image
	 */
	public UploadImage getImage() {
		return image;
	}

	/**
	 * @param image the image to set
	 */
	public void setImage(UploadImage image) {
		this.image = image;
	}

	/**
	 * @return the width
	 */
	public int getWidth() {
		return width;
	}

	/**
	 * @param width the width to set
	 */
	public void setWidth(int width) {
		this.width = width;
	}

	/**
	 * @return the height
	 */
	public int getHeight() {
		return height;
	}

	/**
	 * @param height the height to set
	 */
	public void setHeight(int height) {
		this.height = height;
	}

	/**
	 * @return the scale
	 */
	public int getScale() {
		return scale;
	}

	/**
	 * @param scale the scale to set
	 */
	public void setScale(int scale) {
		this.scale = scale;
	}

	/**
	 * @return the cache
	 */
	public boolean isCache() {
		return cache;
	}

	/**
	 * @param cache the cache to set
	 */
	public void setCache(boolean cache) {
		this.cache = cache;
	}

	/**
	 * @return the bufferSize
	 */
	public int getBufferSize() {
		return bufferSize;
	}

	/**
	 * @param bufferSize the bufferSize to set
	 */
	public void setBufferSize(int bufferSize) {
		this.bufferSize = bufferSize;
	}

	/**
	 * @return the contentDisposition
	 */
	public String getContentDisposition() {
		return contentDisposition;
	}

	/**
	 * @param contentDisposition the contentDisposition to set
	 */
	public void setContentDisposition(String contentDisposition) {
		this.contentDisposition = contentDisposition;
	}

	/**
	 * @return the filename
	 * @throws IOException IOException
	 */
	public String getFn() throws IOException {
		return image.getSaveName();
	}

	/**
	 * @param filename the filename to set
	 * @throws IOException IOException
	 */
	public void setFn(String filename) throws IOException {
		image.setSaveName(filename);
	}

	/**
	 * constructor
	 */
	public ImageServeAction() {
	}

	/**
	 * execute
	 * 
	 * @return result name
	 * @throws Exception if an error occurs
	 */
	public String execute() throws Exception {
		return upload();
	}
	
	/**
	 * upload
	 * 
	 * @return NONE
	 * @throws Exception if an error occurs
	 */
	public String upload() throws Exception {
		if (width > 0 && height > 0) {
			if (image != null && image.getData() != null) {
				image.resize(width, height);
			}
		}
		else if (scale > 0) {
			if (image != null && image.getData() != null) {
				image.resize(scale);
			}
		}
		
		if (image != null) {
			log.debug("UploadImage: " + image.toString());
		}
		return SUCCESS;
	}
	
	/**
	 * download
	 * 
	 * @return NONE
	 * @throws Exception if an error occurs
	 */
	public String download() throws Exception {
		if (image.getFile() == null) {
			return NONE;
		}

		HttpServletRequest servletRequest = getServletRequest();
		HttpServletResponse servletResponse = getServletResponse();

		FileContent fc = image.getFile().getContent();
		String filename = image.getFile().getName().getBaseName();
		
		HttpServletSupport hsrs = new HttpServletSupport(servletRequest, servletResponse);
		
		hsrs.setContentLength(Integer.valueOf((int)fc.getSize()));
		hsrs.setFileName(filename);
		hsrs.setNoCache(!cache);

		hsrs.writeResponseHeader();
		hsrs.writeResponseData(fc.getInputStream(), bufferSize);
		
		return NONE;
	}
}
