/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.actions;

import java.io.OutputStream;
import java.text.MessageFormat;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nuts.core.servlet.HttpServletSupport;
import nuts.core.util.Percent;
import nuts.exts.struts2.util.StrutsContextUtils;

import org.apache.commons.lang.StringEscapeUtils;


/**
 */
@SuppressWarnings("serial")
public class CommonWorkAction extends CommonDataAccessAction {

	private MessageFormat error;
	private MessageFormat process;
	private MessageFormat success;
	private HttpServletRequest request;
	private HttpServletResponse response;
	private OutputStream os;

	/**
	 * @return the error
	 */
	public MessageFormat getError() {
		return error;
	}

	/**
	 * @param error the error to set
	 */
	public void setError(String error) {
		this.error = new MessageFormat(error);
	}

	/**
	 * @return the process
	 */
	public MessageFormat getProcess() {
		return process;
	}

	/**
	 * @param process the process to set
	 */
	public void setProcess(String process) {
		this.process = new MessageFormat(process);
	}

	/**
	 * @return the success
	 */
	public MessageFormat getSuccess() {
		return success;
	}

	/**
	 * @param success the success to set
	 */
	public void setSuccess(String success) {
		this.success = new MessageFormat(success);
	}

	protected void init() throws Exception {
		response = StrutsContextUtils.getServletResponse();
		HttpServletSupport hsrs = new HttpServletSupport(request, response);
		hsrs.setNoCache(true);
		hsrs.setCharset("UTF-8");
		hsrs.setContentType("text/html");
		hsrs.writeResponseHeader();
		
		os = response.getOutputStream();
	}
	
	protected void printProcess(int progress, String msg) {
		printScript(process.format(new Object[] { String.valueOf(progress), StringEscapeUtils.escapeJavaScript(msg) }));
	}
	
	protected void printError(String msg) {
		printScript(error.format(new Object[] { StringEscapeUtils.escapeJavaScript(msg) }));
	}
	
	protected void printSuccess(String msg) {
		printScript(success.format(new Object[] { StringEscapeUtils.escapeJavaScript(msg) }));
	}
	
	protected void printScript(String script) {
		try {
			String s = "<script>" + script + "</script>"; 
			os.write(s.getBytes("UTF-8"));
			os.flush();
		}
		catch (Exception e) {
		}
	}

	protected class ProgressBar extends Percent {
//		private int savePercent = -1;
		private String msg;

		/**
		 * constructor
		 */
		public ProgressBar() {
		}

		/**
		 * @param msg the msg to set
		 */
		public void setMsg(String msg) {
			this.msg = msg;
		}

		/**
		 * @param value value
		 */
		@Override
		public void setValue(long value) {
			super.setValue(value);

			int percent = getPercent();
			printProcess(percent, msg);
//			if (savePercent != percent) {
//				savePercent = percent;
//				printProcess(percent, msg);
//			}
		}
	}
}
