/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.actions;

import java.util.Locale;
import java.util.Map;

import nuts.core.orm.dao.DataAccessSession;
import nuts.exts.xwork2.util.ContextUtils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 */
public class ActionHelper {

	protected static Log log = LogFactory.getLog(ActionHelper.class);

	protected CommonAction action;
	
	/**
	 * Constructor
	 */
	public ActionHelper(CommonAction action) {
		this.action = action;
	}

	/**
	 * @return action
	 */
	public CommonAction getAction() {
		return action;
	}
	
	/**
	 * @return session
	 */
	public Map<String, Object> getSession() {
		return action.getSession();
	}
	
	/**
	 * @return application
	 */
	public Map<String, Object> getApplication() {
		return action.getApplication();
	}
	
	/**
	 * @return locale
	 */
	public Locale getLocale() {
		return action.getLocale();
	}
	
	/**
	 * @return namespace
	 */
	public String getNamespace() {
		return ContextUtils.getNamespace();
	}

	/**
	 * get action name
	 * @return action name
	 */
	public String getActionName() {
		return ContextUtils.getActionName();
	}

	/**
	 * get action method
	 * @return action method
	 */
	public String getActionMethod() {
		return ContextUtils.getActionMethod();
	}

	/**
	 * @return dataAccessSession
	 */
	public DataAccessSession getDataAccessSession() {
		if (action instanceof CommonDataAccessAction) {
			return ((CommonDataAccessAction)action).getDataAccessSession();
		}
		return null;
	}

	/**
	 * @return the utils
	 */
	public ActionUtilities getUtils() {
		return action.getUtils();
	}

	/**
	 * @return the consts
	 */
	public ActionConstants getConsts() {
		return action.getConsts();
	}
}
