/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.actions;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

/**
 */
public class ActionConstants extends ActionHelper {
	protected Map<String, Object> cache = new HashMap<String, Object>();
	
	/**
	 * Constructor
	 */
	public ActionConstants(CommonAction action) {
		super(action);
	}
	
	/**
	 * getTextAsList
	 * @param name name
	 * @return map
	 */
	public List getTextAsList(String name) {
		Object v = cache.get(name);
		if (v instanceof List) {
			return (List)v;
		}

		v = getAction().getTextAsList(name, Collections.EMPTY_LIST);
		cache.put(name, v);
		return (List)v;
	}
	
	/**
	 * getTextAsMap
	 * @param name name
	 * @return map
	 */
	public Map getTextAsMap(String name) {
		Object v = cache.get(name);
		if (v instanceof Map) {
			return (Map)v;
		}

		v = getAction().getTextAsMap(name, Collections.EMPTY_MAP);
		cache.put(name, v);
		return (Map)v;
	}
	
	public Set<String> getCharsets() {
		final String name = "chatsets";
		
		Object v = cache.get(name);
		if (v instanceof Set) {
			return (Set<String>)v;
		}

		SortedMap<String,Charset> map = Charset.availableCharsets();
		v = map.keySet();
		cache.put(name, v);
		return (Set<String>)v;
	}

	
	/**
	 * @return map
	 */
	public Map<String, String> getBooleanMap() {
		return getTextAsMap("const-booleans");
	}

	/**
	 * @return list
	 */
	public List getBloodTypeList() {
		return getTextAsList("const-bloodTypes");
	}
	
	/**
	 * @return map
	 */
	public Map<String, String> getGenderMap() {
		return getTextAsMap("const-genders");
	}
}
