/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2;

import java.util.Locale;

import nuts.exts.exception.UnknownHandlerException;
import nuts.exts.xwork2.util.LocalizedTextUtils;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.UnknownHandler;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.XWorkMessages;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.inject.Inject;

/**
 */
public class ServletUnknownHandler implements UnknownHandler {
	private Configuration configuration;
	private boolean redirectToSlash = true;
	private String welcomeAction = "index";

	/**
	 * @param configuration the configuration to set
	 */
	@Inject
	public void setConfiguration(Configuration configuration) {
		this.configuration = configuration;
	}

	/**
	 * @param redirectToSlash the redirectToSlash to set
	 */
    @Inject(value=NutsStrutsConstants.NUTS_REDIRECT_TO_SLASH, required=false)
	public void setRedirectToSlash(String redirectToSlash) {
		this.redirectToSlash = Boolean.parseBoolean(redirectToSlash);
	}

	/**
	 * @param welcomeAction the welcomeAction to set
	 */
    @Inject(value=NutsStrutsConstants.NUTS_ACTION_WELCOME, required=false)
	public void setWelcomeAction(String welcomeAction) {
		this.welcomeAction = welcomeAction;
	}

	public ActionConfig handleUnknownAction(String namespace, String actionName)
			throws XWorkException {
		if (redirectToSlash) {
			// Strip the namespace if it is just a slash
			if (namespace == null || "/".equals(namespace)) {
				namespace = "";
			}

			String nn = namespace + "/" + actionName;
			ActionConfig actionConfig = configuration.getRuntimeConfiguration().getActionConfig(nn, "");
	        if (actionConfig != null) {
	    		return actionConfig;
	        }

	        actionConfig = configuration.getRuntimeConfiguration().getActionConfig(nn, welcomeAction);
	        if (actionConfig != null) {
	    		return actionConfig;
	        }
		}

		String message;
		if ((namespace != null) && (namespace.trim().length() > 0)) {
			message = LocalizedTextUtils.findDefaultText(
				XWorkMessages.MISSING_PACKAGE_ACTION_EXCEPTION, Locale.getDefault(), new String[] {
						namespace, actionName });
		}
		else {
			message = LocalizedTextUtils.findDefaultText(XWorkMessages.MISSING_ACTION_EXCEPTION,
				Locale.getDefault(), new String[] { actionName });
		}
		throw new UnknownHandlerException(message);
	}

	public Result handleUnknownResult(ActionContext actionContext, String actionName,
			ActionConfig actionConfig, String resultCode) throws XWorkException {
		return null;
	}

	public Object handleUnknownActionMethod(Object action, String methodName)
			throws NoSuchMethodException {
		return null;
	}
}
