/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.oxm.adapter.filters;

import nuts.core.oxm.adapter.PropertyFilter;
import nuts.core.util.Filter;

/**
 */
public class FilterPropertyFilter implements PropertyFilter {
	/**
	 * Constructor
	 */
	public FilterPropertyFilter() {
	}

	/**
	 * @param source the owner of the property
	 * @param name the name of the property
	 * @param value the value of the property
	 * @return true if the property will be filtered out, false otherwise
	 */
	public boolean apply(Object source, String name, Object value) {
		if (!(source instanceof Filter)) {
			throw new IllegalArgumentException();
		}

		Filter filter = (Filter)source;

		if ("n".equals(name)
				|| "c".equals(name)
				|| "t".equals(name)) {
			return false;
		}

		if (Filter.VT_BOOLEAN.equals(filter.getValueType())) {
			if ("bv".equals(name)
					|| "bv2".equals(name)
					|| "bvs".equals(name)) {
				return false;
			}
		}
		else if (Filter.VT_DATE.equals(filter.getValueType())) {
			if ("dv".equals(name)
					|| "dv2".equals(name)
					|| "dvs".equals(name)) {
				return false;
			}
		}
		else if (Filter.VT_NUMBER.equals(filter.getValueType())) {
			if ("nv".equals(name)
					|| "nv2".equals(name)
					|| "nvs".equals(name)) {
				return false;
			}
		}
		else if (Filter.VT_STRING.equals(filter.getValueType())) {
			if ("sv".equals(name)
					|| "sv2".equals(name)
					|| "svs".equals(name)) {
				return false;
			}
		}
		else {
			if ("v".equals(name)
					|| "v2".equals(name)
					|| "vs".equals(name)) {
				return false;
			}
		}

		return true;
	}
}

