/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.lucene;

import org.apache.commons.lang.StringUtils;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;

/**
 */
public class LuceneUtils {
	/**
	 * @return query
	 * @throws ParseException 
	 */
	public static Query parseSimpleQuery(QueryParser parser, String text) throws ParseException {
		text = StringUtils.replaceChars(text, "+-&|!(){}[]^\"~*?:\\", "");
		String[] ts = StringUtils.split(text);
		StringBuilder sb = new StringBuilder();
		for (String s : ts) {
			sb.append(s);
			sb.append("* ");
		}
		return parser.parse(sb.toString());
	}
}
