/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.json.processors;

import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import nuts.core.util.Filter;

/**
 */
public class FilterValueProcessor implements JsonValueProcessor {
	/**
	 * Constructor
	 */
	public FilterValueProcessor() {
	}

	/**
	 * @see net.sf.json.processors.JsonValueProcessor#processArrayValue(java.lang.Object, net.sf.json.JsonConfig)
	 */
	public Object processArrayValue(Object value, JsonConfig jsonConfig) {
		return value;
	}

	/**
	 * @see net.sf.json.processors.JsonValueProcessor#processObjectValue(java.lang.String, java.lang.Object, net.sf.json.JsonConfig)
	 */
	public Object processObjectValue(String key, Object value, JsonConfig jsonConfig) {
		if (value == null) {
			return JSONNull.getInstance();
		}
		
		if (!(value instanceof Filter)) {
			throw new IllegalArgumentException();
		}

		Filter filter = (Filter)value;
		
		JSONObject jo = new JSONObject();

		jo.put("n", filter.getN());
		jo.put("c", filter.getC());
		jo.put("t", filter.getT());
		
		if (Filter.VT_BOOLEAN.equals(filter.getValueType())) {
			jo.put("bv", filter.getBv());
			jo.put("bv2", filter.getBv2());
			jo.put("bvs", filter.getBvs());
		}
		else if (Filter.VT_DATE.equals(filter.getValueType())) {
			jo.put("dv", filter.getDv());
			jo.put("dv2", filter.getDv2());
			jo.put("dvs", filter.getDvs());
		}
		else if (Filter.VT_NUMBER.equals(filter.getValueType())) {
			jo.put("nv", filter.getNv());
			jo.put("nv2", filter.getNv2());
			jo.put("nvs", filter.getNvs());
		}
		else if (Filter.VT_STRING.equals(filter.getValueType())) {
			jo.put("sv", filter.getSv());
			jo.put("sv2", filter.getSv2());
			jo.put("svs", filter.getSvs());
		}
		else {
			jo.put("v", filter.getV());
			jo.put("v2", filter.getV2());
			jo.put("vs", filter.getVs());
		}

		return jo;
	}
}

