/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.freemarker;

import java.io.IOException;
import java.io.Reader;

import freemarker.cache.TemplateLoader;

/**
 * delegate template loader
 */
public class DelegateTemplateLoader implements TemplateLoader {
    
	private TemplateLoader delegate;

	/**
	 * @return the delegate
	 */
	public TemplateLoader getDelegate() {
		return delegate;
	}

	/**
	 * @param delegate the delegate to set
	 */
	public void setDelegate(TemplateLoader delegate) {
		this.delegate = delegate;
	}

    /**
	 * Constructor
	 */
	public DelegateTemplateLoader() {
	}

    /**
	 * Constructor
	 * @param delegate delegate template loader
	 */
	public DelegateTemplateLoader(TemplateLoader delegate) {
		this.delegate = delegate;
	}

	/**
     * @see freemarker.cache.TemplateLoader#closeTemplateSource(java.lang.Object)
     */
    public void closeTemplateSource(Object templateSource) throws IOException {
    	delegate.closeTemplateSource(templateSource);
    }
    
    /**
     * @see freemarker.cache.TemplateLoader#findTemplateSource(java.lang.String)
     */
    public Object findTemplateSource(String name) throws IOException {
        return delegate.findTemplateSource(name);
    }
    
    /**
     * @see freemarker.cache.TemplateLoader#getLastModified(java.lang.Object)
     */
    public long getLastModified(Object templateSource) {
        return delegate.getLastModified(templateSource);
    }
    
    /**
     * @see freemarker.cache.TemplateLoader#getReader(java.lang.Object, java.lang.String)
     */
    public Reader getReader(Object templateSource, String encoding) throws IOException {
        return delegate.getReader(templateSource, encoding);
    }
}
