/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.app;

import nuts.core.lang.ClassUtils;

/**
 */
public class WebPlatform {
	private static boolean gaeSupport;
	
	static {
		try {
			ClassUtils.getClass("nuts.gae.vfs.ngfs.provider.GaeVFS");
			gaeSupport = true;
		}
		catch (Throwable e) {
			gaeSupport = false;
		}
	}

	/**
	 * @return true if gae support
	 */
	public static boolean isGaeSupport() {
		return gaeSupport;
	}
}
