/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.demo.model.dao;

import nuts.core.dao.DaoSession;
import nuts.core.dao.DaoUtils;
import nuts.core.lang.Systems;
import nuts.demo.Application;
import nuts.demo.action.ActionTestCase;
import nuts.demo.model.bean.SampleTags;
import nuts.demo.model.example.SampleTagsExample;

import java.util.List;

public class SampleTagsDAOTest extends ActionTestCase {
	private DaoSession session;
	
	@Override
	protected void setUp() throws Exception {
		session = Application.get().getDataAccessClient().openSession();
		super.setUp();
	}

	@Override
	protected void tearDown() throws Exception {
		DaoUtils.safeClose(session);
		super.tearDown();
	}

	public void testSelectByPrimaryKey() throws Exception {
		SampleTagsDAO dao = new SampleTagsDAO(session);
		
		dao.fetch(1L);
		
		session.commit();
	}

	public void testDeleteByPrimaryKey() throws Exception {
		SampleTagsDAO dao = new SampleTagsDAO(session);
		
		dao.delete(1L);
		
		session.commit();
	}

	public void testUpdateByPrimaryKey() throws Exception {
		SampleTagsDAO dao = new SampleTagsDAO(session);
		
		SampleTags s1 = new SampleTags();
		s1.setId(1L);
		
		dao.update(s1);
		
		session.commit();
	}

	public void testUpdateByPrimaryKeySelective() throws Exception {
		SampleTagsDAO dao = new SampleTagsDAO(session);
		
		SampleTags s1 = new SampleTags();
		s1.setId(1L);
		s1.setBbcodeField("test");
		
		dao.update(s1);
		
		session.commit();
	}

	public void testSelectByExample() throws Exception {
		SampleTagsDAO dao = new SampleTagsDAO(session);
		
		SampleTagsExample exp = dao.createExample();
		
		exp.name().exclude()
			.id().equalTo(1L)
			.name().lessThan("2")
			.intField().between(100, 1000);
		if (Systems.IS_OS_APPENGINE) {
			exp.htmlField().greaterThan("3").bbcodeField().lessThan("4");
		}
		else {
			exp.getConditions().open();
			exp.htmlField().greaterThan("3");
			exp.getConditions().or();
			exp.bbcodeField().lessThan("4");
			exp.getConditions().close();
		}
		exp.dateField().isNull();

		List<SampleTags> list = dao.selectList(exp);
		
		for (SampleTags s : list) {
			assertNotNull(s.getName());
		}
		
		session.commit();
	}

	public void testSelectByExample2() throws Exception {
		SampleTagsDAO dao = new SampleTagsDAO(session);
		
		SampleTagsExample exp = dao.createExample();
		
		exp.excludeALL().name().include()
			.name().in(new String[] { "t3", "t4", "t5" })
			;

		List<SampleTags> list = dao.selectList(exp);
		
		for (SampleTags s : list) {
			assertNotNull(s.getName());
		}
		
		session.commit();
	}

	public void testUpdateByExample() throws Exception {
		SampleTagsDAO dao = new SampleTagsDAO(session);
		
		SampleTags s1 = new SampleTags();
		s1.setId(1L);

		SampleTagsExample exp = dao.createExample();
		exp.name().exclude()
			.id().equalTo(1L)
			.name().lessThan("2")
			.intField().between(100, 1000);
		if (Systems.IS_OS_APPENGINE) {
			exp.htmlField().greaterThan("3").bbcodeField().lessThan("4");
		}
		else {
			exp.getConditions().open();
			exp.htmlField().greaterThan("3");
			exp.getConditions().or();
			exp.bbcodeField().lessThan("4");
			exp.getConditions().close();
		}
		exp.dateField().isNull();

		dao.update(s1, exp);
		
		session.commit();
	}
	
	public void testRollback() throws Exception {
		SampleTagsDAO dao = new SampleTagsDAO(session);
		
		SampleTags s1 = new SampleTags();
		s1.setId(1L);
		
		dao.insert(s1);
		
		s1.setId(2L);
		dao.insert(s1);
		
		session.rollback();
		
		List<SampleTags> ss = dao.selectList(dao.createExample());
		
		System.out.println("select all: " + ss.size());
	}
}
