/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.demo.action.images;

import nuts.core.io.Files;
import nuts.core.servlet.HttpServletSupport;
import nuts.demo.action.AbstractAction;
import nuts.demo.model.bean.SampleFile;
import nuts.demo.model.dao.SampleFileDAO;
import nuts.exts.struts2.util.StrutsContextUtils;

import java.io.InputStream;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 */
public class SampleFileImageAction extends AbstractAction {

	/**
	 * NOIMG = "noimg";
	 */
	protected final static String NOIMG = "noimg";

	protected Long id;
	
	/**
	 * imageName
	 */
	protected String imageName;

	/**
	 * imageType
	 */
	protected String imageType;

	/**
	 * imageSize
	 */
	protected Integer imageSize;
	
	/**
	 * imageStream
	 */
	protected InputStream imageStream;

	/**
	 * @return the imageName
	 */
	public String getImageName() {
		return imageName;
	}

	/**
	 * @param imageName the imageName to set
	 */
	public void setImageName(String imageName) {
		this.imageName = imageName;
	}

	/**
	 * @return the imageType
	 */
	public String getImageType() {
		if (imageType == null) {
			imageType = Files.getContentTypeFor(imageName);
		}
		return imageType;
	}

	/**
	 * @param imageType the imageType to set
	 */
	public void setImageType(String imageType) {
		this.imageType = imageType;
	}

	/**
	 * @return the imageSize
	 */
	public int getImageSize() {
		return imageSize;
	}

	/**
	 * @param imageSize the imageSize to set
	 */
	public void setImageSize(int imageSize) {
		this.imageSize = imageSize;
	}

	/**
	 * @return the imageStream
	 */
	public InputStream getImageStream() {
		return imageStream;
	}

	/**
	 * @param imageStream the imageStream to set
	 */
	public void setImageStream(InputStream imageStream) {
		this.imageStream = imageStream;
	}

	/**
	 * @return the id
	 */
	public Long getId() {
		return id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(Long id) {
		this.id = id;
	}

	/**
	 * execute
	 * @return result name
	 * @throws Exception if an error occurs
	 */
	public String execute() throws Exception {
		HttpServletRequest req = StrutsContextUtils.getServletRequest();
		HttpServletResponse res = StrutsContextUtils.getServletResponse();
		
		if (id != null) {
			SampleFileDAO dao = new SampleFileDAO(getDataAccessSession());
			SampleFile sf = dao.fetch(id);
			if (sf != null && sf.getImageField() != null && sf.getImageField().getData() != null) {
				HttpServletSupport hsrs = new HttpServletSupport(req, res);
				hsrs.setFileName("SampleFile_Image_" + id);
				hsrs.setContentType("image");
				hsrs.setContentLength(sf.getImageField().getData().length);
				hsrs.writeResponseHeader();
				hsrs.writeResponseData(sf.getImageField().getData());
				return NONE;
			}
		}

		res.sendError(HttpServletResponse.SC_NOT_FOUND);
		return NOIMG;
	}
}