/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.demo.action;

import nuts.core.lang.Numbers;


/**
 * SuccessAction
 */
public class SuccessAction extends AbstractAction {

	private String delay;
	
	public SuccessAction() {
		super();
	}
	
	/**
	 * @return the delay
	 */
	public String getDelay() {
		return delay;
	}

	/**
	 * @param delay the delay to set
	 */
	public void setDelay(String delay) {
		this.delay = delay;
	}

	/**
	 * execute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String execute() throws Exception {
		return doExecute(SUCCESS);
	}

	/**
	 * success
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String success() throws Exception {
		return doExecute(SUCCESS);
	}

	/**
	 * none
	 * @return NONE
	 * @throws Exception if an error occurs
	 */
	public String none() throws Exception {
		return doExecute(NONE);
	}
	
	private String doExecute(String rv) {
		int sec = Numbers.toInt(delay, 0);
		if (sec > 0) {
			try {
				Thread.sleep(sec * 1000);
			} 
			catch (InterruptedException e) {
				// ignore
			}
		}
		return rv;
	}
}
