/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.demo.action.sample;

import nuts.core.servlet.ServletRequestHeaderMap;
import nuts.exts.struts2.actions.CommonAction;
import nuts.exts.struts2.util.StrutsContextUtils;

import java.util.Map;

/**
 */
public class DebugAction extends CommonAction {
	private Map<String, Object> headers;
	
	/**
	 * @return the headers
	 */
	public Map<String, Object> getHeaders() {
		return headers;
	}

	public Map<String, String[]> getParams() {
		return getParameters();
	}
	
	private void process() {
		headers = new ServletRequestHeaderMap(StrutsContextUtils.getServletRequest());
	}
	
	/**
	 * @throws Exception if an error occurs
	 */
	public String ftl() throws Exception {
		process();
		return SUCCESS;
	}

	/**
	 * @throws Exception if an error occurs
	 */
	public String json() throws Exception {
		process();
		return JSON;
	}

	/**
	 * @throws Exception if an error occurs
	 */
	public String xml() throws Exception {
		process();
		return XML;
	}
}
