/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.demo.action.images;

import nuts.core.io.Files;
import nuts.core.servlet.HttpServletSupport;
import nuts.demo.action.AbstractAction;
import nuts.demo.model.bean.SampleFile;
import nuts.demo.model.dao.SampleFileDAO;
import nuts.exts.struts2.util.StrutsContextUtils;

import java.io.InputStream;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 */
public class SampleFileFileAction extends AbstractAction {

	protected Long id;
	
	/**
	 * fileName
	 */
	protected String fileName;

	/**
	 * fileType
	 */
	protected String fileType;

	/**
	 * fileStream
	 */
	protected InputStream fileStream;

	/**
	 * @return the fileName
	 */
	public String getFileName() {
		return fileName;
	}

	/**
	 * @param fileName the fileName to set
	 */
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	/**
	 * @return the fileType
	 */
	public String getFileType() {
		if (fileType == null) {
			fileType = Files.getContentTypeFor(fileName);
		}
		return fileType;
	}

	/**
	 * @param fileType the fileType to set
	 */
	public void setFileType(String fileType) {
		this.fileType = fileType;
	}

	/**
	 * @return the fileStream
	 */
	public InputStream getFileStream() {
		return fileStream;
	}

	/**
	 * @param fileStream the fileStream to set
	 */
	public void setFileStream(InputStream fileStream) {
		this.fileStream = fileStream;
	}

	/**
	 * @return the id
	 */
	public Long getId() {
		return id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(Long id) {
		this.id = id;
	}

	/**
	 * execute
	 * @return result name
	 * @throws Exception if an error occurs
	 */
	public String execute() throws Exception {
		HttpServletRequest req = StrutsContextUtils.getServletRequest();
		HttpServletResponse res = StrutsContextUtils.getServletResponse();
		
		if (id != null) {
			SampleFileDAO dao = new SampleFileDAO(getDaoSession());
			SampleFile sf = dao.fetch(id);
			if (sf != null && sf.getFileField() != null && sf.getFileField().getData() != null) {
				HttpServletSupport hsrs = new HttpServletSupport(req, res);
				hsrs.setFileName("SampleFile_File_" + id);
				hsrs.setContentLength(sf.getFileField().getData().length);
				hsrs.writeResponseHeader();
				hsrs.writeResponseData(sf.getFileField().getData());
				return NONE;
			}
		}

		res.sendError(HttpServletResponse.SC_NOT_FOUND);
		return NONE;
	}
}