/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.net;

import junit.framework.TestCase;

import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;


/**
 * a test class for SendMail
 * @see SendMail
 */
public class SendMailTest extends TestCase {

	/**
	 */
	public void testSend() {
		try {
			Email email = new SimpleEmail();

//			email.setHostName("lcmail01.linkcafe.ne.jp");
//			email.setLocalhost("lcmail01.linkcafe.ne.jp");
			email.setDebug(true);
			email.setCharset("UTF-8");
			email.setFrom("test@gmail.com");
			email.setSubject("test subject");
//			email.addTo("unhou.ou@u-s-systems.co.jp", "frank.wang");
			email.addTo("fireswan@hotmail.com", "frank.wang");
			email.addTo("squirrels.gallery@gmail.com", "frank.wang");
			email.setMsg("this is a test email");

//			email.buildMimeMessage();
//			email.getMimeMessage();

//			email.send();
			SendMail.send(email);
		}
		catch (EmailException e) {
			e.printStackTrace();
			fail();
		}
	}

}
