/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang.i18n;

import nuts.core.lang.i18n.AsiaChars;

import junit.framework.TestCase;

/**
 * test class for AsiaCharUtils
 */
public class AsiaCharsTest extends TestCase {

	/**
	 * test method: IsHankakuKatakanaChar
	 */
	public void testIsHankakuKatakanaChar() {
		assertFalse(AsiaChars.isHankakuKatakanaChar('a'));
		assertTrue(AsiaChars.isHankakuKatakanaChar('\uff88'));
	}

	/**
	 * test method: isZenkakuKatakanaChar
	 */
	public void testIsZenkakuKatakanaChar() {
		assertFalse(AsiaChars.isZenkakuKatakanaChar('a'));
		assertTrue(AsiaChars.isZenkakuKatakanaChar('\u30a1'));
	}

	/**
	 * test method: isHankakuChar
	 */
	public void testIsHankakuChar() {
		assertFalse(AsiaChars.isHankakuChar('\250'));
		assertFalse(AsiaChars.isHankakuChar('\u300b'));
		assertTrue(AsiaChars.isHankakuChar('a'));
	}

	/**
	 * test method: isZenkakuChar
	 */
	public void testIsZenkakuChar() {
		assertFalse(AsiaChars.isZenkakuChar('a'));
		assertTrue(AsiaChars.isZenkakuChar('\u3011'));
	}

}
