/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang.escape;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import org.junit.Test;

/**
 * Unit tests for {@link UnicodeEscaper}.
 */
public class UnicodeUnescaperTest {

	// Requested in LANG-507
	@Test
	public void testUPlus() {
		final UnicodeUnescaper uu = new UnicodeUnescaper();

		final String input = "\\u+0047";
		assertEquals("Failed to unescape Unicode characters with 'u+' notation", "G", uu.translate(input));
	}

	@Test
	public void testUuuuu() {
		final UnicodeUnescaper uu = new UnicodeUnescaper();

		final String input = "\\uuuuuuuu0047";
		final String result = uu.translate(input);
		assertEquals("Failed to unescape Unicode characters with many 'u' characters", "G", result);
	}

	@Test
	public void testLessThanFour() {
		final UnicodeUnescaper uu = new UnicodeUnescaper();

		final String input = "\\0047\\u006";
		try {
			uu.translate(input);
			fail("A lack of digits in a Unicode escape sequence failed to throw an exception");
		}
		catch (final IllegalArgumentException iae) {
			// expected
		}
	}
}
