/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang.escape;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

/**
 * Unit tests for {@link UnicodeEscaper}.
 */
public class UnicodeEscaperTest  {

	@Test
	public void testBelow() {
		final UnicodeEscaper ue = UnicodeEscaper.below('F');

		final String input = "ADFGZ";
		final String result = ue.translate(input);
		assertEquals("Failed to escape Unicode characters via the below method", "\\u0041\\u0044FGZ", result);
	}

	@Test
	public void testBetween() {
		final UnicodeEscaper ue = UnicodeEscaper.between('F', 'L');

		final String input = "ADFGZ";
		final String result = ue.translate(input);
		assertEquals("Failed to escape Unicode characters via the between method", "AD\\u0046\\u0047Z", result);
	}

	@Test
	public void testAbove() {
		final UnicodeEscaper ue = UnicodeEscaper.above('F');

		final String input = "ADFGZ";
		final String result = ue.translate(input);
		assertEquals("Failed to escape Unicode characters via the above method", "ADF\\u0047\\u005A", result);
	}
}
