/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang.escape;

import org.junit.Test;
import static org.junit.Assert.*;

/**
 * Unit tests for {@link OctalUnescaper}.
 */
public class OctalUnescaperTest {

	@Test
	public void testBetween() {
		final OctalUnescaper oue = new OctalUnescaper(); // .between("1", "377");

		String input = "\\45";
		String result = oue.translate(input);
		assertEquals("Failed to unescape octal characters via the between method", "\45", result);

		input = "\\377";
		result = oue.translate(input);
		assertEquals("Failed to unescape octal characters via the between method", "\377", result);

		input = "\\377 and";
		result = oue.translate(input);
		assertEquals("Failed to unescape octal characters via the between method", "\377 and", result);

		input = "\\378 and";
		result = oue.translate(input);
		assertEquals("Failed to unescape octal characters via the between method", "\378 and", result);

		input = "\\378";
		result = oue.translate(input);
		assertEquals("Failed to unescape octal characters via the between method", "\378", result);

		input = "\\1";
		result = oue.translate(input);
		assertEquals("Failed to unescape octal characters via the between method", "\1", result);
	}

}
