/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang.escape;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

/**
 * Unit tests for {@link NumericEntityEscaper}.
 */
public class NumericEntityEscaperTest {

	@Test
	public void testBelow() {
		final NumericEntityEscaper nee = NumericEntityEscaper.below('F');

		final String input = "ADFGZ";
		final String result = nee.translate(input);
		assertEquals("Failed to escape numeric entities via the below method", "&#65;&#68;FGZ", result);
	}

	@Test
	public void testBetween() {
		final NumericEntityEscaper nee = NumericEntityEscaper.between('F', 'L');

		final String input = "ADFGZ";
		final String result = nee.translate(input);
		assertEquals("Failed to escape numeric entities via the between method", "AD&#70;&#71;Z", result);
	}

	@Test
	public void testAbove() {
		final NumericEntityEscaper nee = NumericEntityEscaper.above('F');

		final String input = "ADFGZ";
		final String result = nee.translate(input);
		assertEquals("Failed to escape numeric entities via the above method", "ADF&#71;&#90;", result);
	}

	// See LANG-617
	@Test
	public void testSupplementary() {
		final NumericEntityEscaper nee = new NumericEntityEscaper();
		final String input = "\uD803\uDC22";
		final String expected = "&#68642;";

		final String result = nee.translate(input);
		assertEquals("Failed to escape numeric entities supplementary characters", expected, result);

	}

}
