/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang.escape;

import static org.junit.Assert.assertEquals;

import java.io.IOException;
import java.io.StringWriter;

import org.junit.Test;

/**
 * Unit tests for {@link LookupTranslator}.
 */
public class LookupTranslatorTest {

	@Test
	public void testBasicLookup() throws IOException {
		final LookupTranslator lt = new LookupTranslator(new CharSequence[][] { { "one", "two" } });
		final StringWriter out = new StringWriter();
		final int result = lt.translate("one", 0, out);
		assertEquals("Incorrect codepoint consumption", 3, result);
		assertEquals("Incorrect value", "two", out.toString());
	}

	// Tests: https://issues.apache.org/jira/browse/LANG-882
	@Test
	public void testLang882() throws IOException {
		final LookupTranslator lt = new LookupTranslator(new CharSequence[][] { { new StringBuffer("one"),
				new StringBuffer("two") } });
		final StringWriter out = new StringWriter();
		final int result = lt.translate(new StringBuffer("one"), 0, out);
		assertEquals("Incorrect codepoint consumption", 3, result);
		assertEquals("Incorrect value", "two", out.toString());
	}

}
