/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang.escape;

import static org.junit.Assert.assertTrue;

import java.util.HashSet;
import java.util.Set;

import org.junit.Test;

/**
 * Unit tests for {@link EntityArrays}.
 */
public class EntityArraysTest  {

	@Test
	public void testConstructorExists() {
		new EntityArrays();
	}

	// LANG-659 - check arrays for duplicate entries
	@Test
	public void testHTML40_EXTENDED_ESCAPE() {
		final Set<String> col0 = new HashSet<String>();
		final Set<String> col1 = new HashSet<String>();
		final String[][] sa = EntityArrays.HTML40_EXTENDED_ESCAPE();
		for (int i = 0; i < sa.length; i++) {
			assertTrue("Already added entry 0: " + i + " " + sa[i][0], col0.add(sa[i][0]));
			assertTrue("Already added entry 1: " + i + " " + sa[i][1], col1.add(sa[i][1]));
		}
	}

	// LANG-658 - check arrays for duplicate entries
	@Test
	public void testISO8859_1_ESCAPE() {
		final Set<String> col0 = new HashSet<String>();
		final Set<String> col1 = new HashSet<String>();
		final String[][] sa = EntityArrays.ISO8859_1_ESCAPE();
		boolean success = true;
		for (int i = 0; i < sa.length; i++) {
			final boolean add0 = col0.add(sa[i][0]);
			final boolean add1 = col1.add(sa[i][1]);
			if (!add0) {
				success = false;
				System.out.println("Already added entry 0: " + i + " " + sa[i][0] + " " + sa[i][1]);
			}
			if (!add1) {
				success = false;
				System.out.println("Already added entry 1: " + i + " " + sa[i][0] + " " + sa[i][1]);
			}
		}
		assertTrue("One or more errors detected", success);
	}

}
