/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang.builder;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

/**
 * Test case for ToStringStyle.
 * 
 * @version $Id: ToStringStyleTest.java 1436770 2013-01-22 07:09:45Z ggregory $
 */
public class ToStringStyleTest {

	private static class ToStringStyleImpl extends ToStringStyle {
		private static final long serialVersionUID = 1L;
	}

	// -----------------------------------------------------------------------
	@Test
	public void testSetArrayStart() {
		final ToStringStyle style = new ToStringStyleImpl();
		style.setArrayStart(null);
		assertEquals("", style.getArrayStart());
	}

	@Test
	public void testSetArrayEnd() {
		final ToStringStyle style = new ToStringStyleImpl();
		style.setArrayEnd(null);
		assertEquals("", style.getArrayEnd());
	}

	@Test
	public void testSetArraySeparator() {
		final ToStringStyle style = new ToStringStyleImpl();
		style.setArraySeparator(null);
		assertEquals("", style.getArraySeparator());
	}

	@Test
	public void testSetContentStart() {
		final ToStringStyle style = new ToStringStyleImpl();
		style.setContentStart(null);
		assertEquals("", style.getContentStart());
	}

	@Test
	public void testSetContentEnd() {
		final ToStringStyle style = new ToStringStyleImpl();
		style.setContentEnd(null);
		assertEquals("", style.getContentEnd());
	}

	@Test
	public void testSetFieldNameValueSeparator() {
		final ToStringStyle style = new ToStringStyleImpl();
		style.setFieldNameValueSeparator(null);
		assertEquals("", style.getFieldNameValueSeparator());
	}

	@Test
	public void testSetFieldSeparator() {
		final ToStringStyle style = new ToStringStyleImpl();
		style.setFieldSeparator(null);
		assertEquals("", style.getFieldSeparator());
	}

	@Test
	public void testSetNullText() {
		final ToStringStyle style = new ToStringStyleImpl();
		style.setNullText(null);
		assertEquals("", style.getNullText());
	}

	@Test
	public void testSetSizeStartText() {
		final ToStringStyle style = new ToStringStyleImpl();
		style.setSizeStartText(null);
		assertEquals("", style.getSizeStartText());
	}

	@Test
	public void testSetSizeEndText() {
		final ToStringStyle style = new ToStringStyleImpl();
		style.setSizeEndText(null);
		assertEquals("", style.getSizeEndText());
	}

	@Test
	public void testSetSummaryObjectStartText() {
		final ToStringStyle style = new ToStringStyleImpl();
		style.setSummaryObjectStartText(null);
		assertEquals("", style.getSummaryObjectStartText());
	}

	@Test
	public void testSetSummaryObjectEndText() {
		final ToStringStyle style = new ToStringStyleImpl();
		style.setSummaryObjectEndText(null);
		assertEquals("", style.getSummaryObjectEndText());
	}

	/**
	 * An object used to test {@link ToStringStyle}.
	 */
	static class Person {
		/**
		 * Test String field.
		 */
		String name;

		/**
		 * Test integer field.
		 */
		int age;

		/**
		 * Test boolean field.
		 */
		boolean smoker;
	}
}
