/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;

import junit.framework.TestCase;

/**
 */
public final class TypesTest extends TestCase {

	List<Integer> listOfInteger = null;
	List<Number> listOfNumber = null;
	List<String> listOfString = null;
	List<?> listOfUnknown = null;
	List<Set<String>> listOfSetOfString = null;
	List<Set<?>> listOfSetOfUnknown = null;

	public void testEquals() throws Exception {
		Type e = getClass().getDeclaredField("listOfString").getGenericType();
		Type a = Types.paramTypeOf(List.class, String.class);

		assertTrue(e.equals(a));
		assertTrue(a.equals(e));
	}
	
	public void testGetDeclaredFieldType() throws Exception {
		assertEquals(Types.paramTypeOf(List.class, Integer.class), 
			Types.getDeclaredFieldType(TypesTest.class, "listOfInteger"));
		assertEquals(Types.paramTypeOf(List.class, Number.class), 
			Types.getDeclaredFieldType(TypesTest.class, "listOfNumber"));
		assertEquals(Types.paramTypeOf(List.class, String.class), 
			Types.getDeclaredFieldType(TypesTest.class, "listOfString"));
		
	}
}
