/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;

import junit.framework.TestCase;

/**
 */
public final class TypeTokenTest extends TestCase {

	List<Integer> listOfInteger = null;
	List<Number> listOfNumber = null;
	List<String> listOfString = null;
	List<?> listOfUnknown = null;
	List<Set<String>> listOfSetOfString = null;
	List<Set<?>> listOfSetOfUnknown = null;

	private void checkCollectionElementType(Type expected, String field) throws Exception {
		Type t = getClass().getDeclaredField(field).getGenericType();
		TypeToken tt = TypeToken.get(t);
		Type actual = Types.getCollectionElementType(tt);
		assertEquals(expected, actual);
	}

	public void testGetCollectionElementType() throws Exception {
		checkCollectionElementType(String.class, "listOfString");
	}

	public void testOurTypeFunctionality() throws Exception {
		ParameterizedType ourType = Types.paramTypeOfOwner(null, List.class, String.class);

		Type parameterizedType = new TypeToken<List<String>>() {}.getType();
		assertNull(ourType.getOwnerType());
		assertEquals(String.class, ourType.getActualTypeArguments()[0]);
		assertEquals(List.class, ourType.getRawType());
		assertEquals(parameterizedType, ourType);
		assertEquals(parameterizedType.hashCode(), ourType.hashCode());
	}

	public void testNotEquals() throws Exception {
		ParameterizedType ourType = Types.paramTypeOfOwner(null, List.class, String.class);

		Type differentParameterizedType = new TypeToken<List<Integer>>() {}.getType();
		assertFalse(differentParameterizedType.equals(ourType));
		assertFalse(ourType.equals(differentParameterizedType));
	}
}
