/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang;

import junit.framework.TestCase;

/**
 * test class for StringEncrypts
 */
public class StringEncryptsTest extends TestCase {
	private void encdec(String key, String trans) throws Exception {
		String text = "trustme";

		String enc = StringEncrypts.encrypt(text, key, trans);
		String dec = StringEncrypts.decrypt(enc, key, trans);
		
		assertEquals(text, dec);
	}

	public void testBlowfish() throws Exception {
		encdec("nuts", Encrypts.ENCRYPT_Blowfish);
	}

//	public void testDES() throws Exception {
//		encdec("1234567", "DES");
//	}

	public void testAES() throws Exception {
		encdec("1234567890123456", Encrypts.ENCRYPT_AES);
	}
}
