/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang;

import junit.framework.TestCase;

/**
 */
public class NumbersTest extends TestCase {
	/**
	 * test method: toInt
	 * @throws Exception if an error occurs
	 */
	public void testToInt() throws Exception {
		assertEquals(new Integer(123), Numbers.toInt("123"));
		assertEquals(new Integer(0), Numbers.toInt("", 0));
	}

	/**
	 * test method: toLong
	 * @throws Exception if an error occurs
	 */
	public void testToLong() throws Exception {
		assertEquals(new Long(123), Numbers.toLong("123"));
	}
}
