/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang;

import org.junit.Assert;
import org.junit.Test;

/**
 * Tests CharSequences
 *
 */
public class CharSequencesTest {

    
    //-----------------------------------------------------------------------
    @Test
    public void testSubSequence() {
        //
        // null input
        //
        Assert.assertEquals(null, CharSequences.subSequence(null, -1));
        Assert.assertEquals(null, CharSequences.subSequence(null, 0));
        Assert.assertEquals(null, CharSequences.subSequence(null, 1));
        //
        // non-null input
        //
        Assert.assertEquals(Strings.EMPTY, CharSequences.subSequence(Strings.EMPTY, 0));
        Assert.assertEquals("012", CharSequences.subSequence("012", 0));
        Assert.assertEquals("12", CharSequences.subSequence("012", 1));
        Assert.assertEquals("2", CharSequences.subSequence("012", 2));
        Assert.assertEquals(Strings.EMPTY, CharSequences.subSequence("012", 3));
        //
        // Exception expected
        //
        try {
            Assert.assertEquals(null, CharSequences.subSequence(Strings.EMPTY, -1));
            Assert.fail("Expected " + IndexOutOfBoundsException.class.getName());
        } catch (final IndexOutOfBoundsException e) {
            // Expected
        }
        try {
            Assert.assertEquals(null, CharSequences.subSequence(Strings.EMPTY, 1));
            Assert.fail("Expected " + IndexOutOfBoundsException.class.getName());
        } catch (final IndexOutOfBoundsException e) {
            // Expected
        }
    }

}
