/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.io;

import junit.framework.TestCase;

/**
 */
public class FilesTest extends TestCase {

	/**
	 * test method: GetFileName
	 */
	public void testGetFileName() {
		assertEquals("1.js", Files.getFileName("/a/1.js"));
	}

	/**
	 * test method: GetFileNameExtension
	 */
	public void testGetFileNameExtension() {
		assertEquals("js", Files.getFileNameExtension("/a/1.js"));
		assertEquals("", Files.getFileNameExtension("/a/2"));
	}

	/**
	 * test method: GetContentTypeForName
	 */
	public void testGetContentTypeForName() {
		assertEquals("image/gif", Files.getContentTypeFor("/a/s1.gif"));
		System.out.println(Files.getContentTypeFor("1.js"));
		System.out.println(Files.getContentTypeFor("c.css"));
	}

	/**
	 * test method: isAbsolutePath
	 */
	public void testIsAbsolutePath() {
		assertTrue(Files.isAbsolutePath("/a/s1.gif"));
		assertTrue(Files.isAbsolutePath("C:/1.js"));
		assertTrue(Files.isAbsolutePath("C:\\1.js"));
		assertFalse(Files.isAbsolutePath("c.css"));
	}

}
