/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.algorithm;

import nuts.core.algorithm.BubbleSorter;

import java.util.Random;

import junit.framework.TestCase;

/**
 */
public class BubbleSorterTest extends TestCase {
	
	protected void randomTest(int n) {
		Random r = new Random();
		
		Integer[] a = new Integer[n]; 
		for (int i = 0; i < a.length; i++) {
			a[i] = r.nextInt();
		}
		
//		System.out.println(StringUtils.join(a, ", "));

		BubbleSorter bs = new BubbleSorter();
		bs.sort(a, 1, a.length - 1);
		
//		System.out.println(StringUtils.join(a, ", "));

		assertTrue(bs.verify(a, 1, a.length - 1));
	}
	
	public void testRandom() {
		for (int i = 1; i < 100; i++) {
			randomTest(i);
		}
	}
}
