/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.util.progressbar;

import java.io.PrintStream;

import nuts.core.lang.Strings;

/**
 * remain time information of progress on console
 */
public class ConsoleRemainTimeBar extends ConsoleProgressBar {

	private long startTime;
	
	private long lastTime;
	
	/**
	 * constructor
	 */
	public ConsoleRemainTimeBar() {
		super();
		
		setSpeed(500);
		setSize(8);
	}

	/**
	 * constructor
	 * @param out output
	 */
	public ConsoleRemainTimeBar(PrintStream out) {
		super(out);
		
		setSpeed(500);
		setSize(8);
	}

	
	/**
	 * @see ConsoleProgressBar#start()
	 */
	@Override
	public void start() {
		startTime = System.currentTimeMillis();
		lastTime = startTime;
		super.start();
	}

	/**
	 * draw progress
	 */
	protected void draw() {
		clear();

		String st;
		if (value <= min) {
			st = "??:??:??";
		}
		else {
			lastTime = System.currentTimeMillis();

			long elapsedTime = lastTime - startTime;
			
			long remainTime = (long)(elapsedTime / (value - min) * (max - value));
			long remainSecond = remainTime / 1000;
			
			long hh = remainSecond / 3600;
			long mm = remainSecond % 3600; mm /= 60;
			long ss = remainSecond % 60;
	
			st = Strings.leftPad(String.valueOf(hh), 2, '0') 
					+ ':' 
					+ Strings.leftPad(String.valueOf(mm), 2, '0')
					+ ':'
					+ Strings.leftPad(String.valueOf(ss), 2, '0');
		}
		
		setSize(st.length());
		
		out.print(st);
		out.flush();
	}

}
