/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.util.progressbar;

import nuts.core.lang.Arrays;

import java.io.PrintStream;

/**
 * Progress bar of console
 */
public abstract class ConsoleProgressBar extends AbstractProgressBar {

	protected final static char BACKSPACE = '\b';
	
	protected PrintStream out;
	
	protected int size;
	
	protected char[] line;
	
	/**
	 * constructor
	 */
	public ConsoleProgressBar() {
		this(System.out);
	}

	/**
	 * constructor
	 * @param out output
	 */
	public ConsoleProgressBar(PrintStream out) {
		super();
		this.out = out;
	}

	/**
	 * @return out
	 */
	public PrintStream getOut() {
		return out;
	}

	/**
	 * @param out out
	 */
	public void setOut(PrintStream out) {
		this.out = out;
	}

	/**
	 * @return size
	 */
	public int getSize() {
		return size;
	}

	/**
	 * @param size size
	 */
	public void setSize(int size) {
		if (this.size != size) {
			this.size = size;
			line = new char[size];
		}
	}

	/**
	 * space
	 */
	protected void space() {
		Arrays.fill(line, ' ');
		out.print(line);
	}

	/**
	 * clear
	 */
	protected void clear() {
		Arrays.fill(line, BACKSPACE);
		out.print(line);
	}
}
